unit Reg;

interface
uses
  FBReplConst, Registry, Inifiles, Forms, SysUtils;

procedure Read_Registry;

implementation

procedure Read_Registry;
begin
  ReplIni := TIniFile.Create(IniFile);
  with ReplIni do begin
    // Server Settings
    brEvtStr := ReadBool('ReplServer', 'EventResp', False);
    srInterval := ReadString('ReplServer', 'Interval', '0');
    brUseEmailAlerts := ReadBool('ReplServer', 'EmailAlerts', False);
    srEmail := ReadString('ReplServer', 'EmailAlertAddress', 'Not Found');
    srFromAddress := ReadString('ReplServer', 'EmailFromAddress', 'meta.com.au');
    srSMTPHost := ReadString('ReplServer', 'SMTPHost', 'localhost');
    srSMTPLogin := ReadString('ReplServer', 'SMTPLogin', 'Not Found');
    srSMTPPWord := ReadString('ReplServer', 'SMTPPWord', 'Not Found');
    brUseSMTPAuthentication := ReadBool('ReplServer', 'UseSMTPAuthentication', False);
    irTolerance := ReadInteger('ReplServer', 'eTolerance', 5);
    irHeartBeat := ReadInteger('ReplServer', 'HeartBeatCycle', 5);
    srReplLogFile := ReadString('ReplServer', 'LogFile', 'FBReplication.log');
    brVerbose := ReadBool('ReplServer', 'Logging', False);
    brShowStats := ReadBool('ReplServer', 'Stats', False);
    irMaxBlobSize := ReadInteger('ReplServer', 'BlobMaxBytes', MaxBlobSize);
    breHeartbeat := ReadBool('ReplServer', 'eHeartbeat', True);

    // Management Settings
    srReplServer := ReadString('ReplMgmt', 'Server', 'Not Found');
    srReplPath := ReadString('ReplMgmt', 'Path', 'Not Found');
    srReplUser := ReadString('ReplMgmt', 'UserName', 'Not Found');
    srReplPWord := ReadString('ReplMgmt', 'Password', 'Not Found');
    Free;
  end;
end;

end.


