unit OpenDb;

interface

uses Windows, SysUtils, Classes, Graphics, Forms, Controls, StdCtrls, 
  Buttons, ExtCtrls, Dialogs, IniFiles, Reg, Mask, DBCtrls, IB_Components, FBReplConst;

const
  DEFAULT_PATH='server[/port]:drive:\path\filename.ext';
  
type
  TOpenDBDlg = class(TForm)
    OKBtn: TButton;
    CancelBtn: TButton;
    Bevel1: TBevel;
    Button1: TButton;
    Label1: TLabel;
    OpenDialog1: TOpenDialog;
    ComboBox1: TComboBox;
    StaticText1: TStaticText;
    StaticText2: TStaticText;
    GroupBox1: TGroupBox;
    Label6: TLabel;
    Label7: TLabel;
    GroupBox2: TGroupBox;
    Label12: TLabel;
    Label13: TLabel;
    Edit1: TEdit;
    Edit2: TEdit;
    StaticText3: TStaticText;
    Edit3: TEdit;
    Edit4: TEdit;
    BitBtn1: TBitBtn;
    IB_Connection1: TIB_Connection;
    BitBtn2: TBitBtn;
    Edit5: TEdit;
    procedure Button1Click(Sender: TObject);
    procedure CancelBtnClick(Sender: TObject);
    procedure OKBtnClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormDestroy(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
  private
    { Private declarations }
  public
    bmServerOK: Boolean;
  end;

var
  OpenDBDlg: TOpenDBDlg;
  IniFile: TIniFile;

implementation

uses rmgr1;

{$R *.DFM}

procedure TOpenDBDlg.Button1Click(Sender: TObject);
begin
  OpenDialog1.Execute;
  ComboBox1.Text := OpenDialog1.FileName;
end;

procedure TOpenDBDlg.CancelBtnClick(Sender: TObject);
begin
  ReplManagerShell.OUserName := '';
  ReplManagerShell.OPassword := '';
  ReplManagerShell.RUserName := '';
  ReplManagerShell.RPassword := '';
  WriteFormPosition(self);
end;

procedure TOpenDBDlg.OKBtnClick(Sender: TObject);
var
  compstr: string;
begin
  if (Caption='Add Source Database') then
    compstr := ComboBox1.Text
  else
    compstr := Edit5.Text;
  if( CompareText(compstr, DEFAULT_PATH) <> 0 ) and bmServerOK then begin
    if (Caption='Add Source Database') then
      ReplManagerShell.ADBPath := ComboBox1.Text
    else
      ReplManagerShell.ADBPath := Edit5.Text;
    ReplManagerShell.OUserName := Uppercase(Edit1.Text);
    ReplManagerShell.OPassword := Edit2.Text;
    ReplManagerShell.RUserName := Uppercase(Edit3.Text);
    ReplManagerShell.RPassword := Edit4.Text;
    ModalResult := mrOK;
  end else
    ModalResult := mrCancel;
end;

procedure TOpenDBDlg.FormShow(Sender: TObject);
var
  Idents: TStringList;
  Path: string;
  i: Integer;
begin
  Idents := TStringList.Create;
  ComboBox1.Items.Clear;
//  Edit1.Text := '';
//  Edit2.Text := '';

  IniFile := TIniFile.Create('FBREPL.INI');

  IniFile.ReadSection('Paths', Idents );

  for i := 0 to Idents.Count - 1 do
  begin
    ComboBox1.Items.Add(IniFile.ReadString('Paths', Idents[i], ''));
  end;
end;

procedure TOpenDBDlg.FormClose(Sender: TObject; var Action: TCloseAction);
var
  i: Integer;
  New: Boolean;
begin
  New := True;
  for i := 0 to (ComboBox1.Items.Count - 1) do
  begin
    if( CompareText(ComboBox1.Items[i], ComboBox1.Text ) = 0 ) then
    begin
      New := False;
      break;
    end;
  end;

  if( ( New ) and
      ( CompareText(ComboBox1.Text, DEFAULT_PATH) <> 0 )) then
    ComboBox1.Items.Insert(0, ComboBox1.Text);

  if( ComboBox1.Items.Count > 10 ) then
    ComboBox1.Items.Delete(10);

  for i:=0 to (ComboBox1.Items.Count -1) do
  begin
    IniFile.WriteString('Paths', 'Path' + IntToStr(i), ComboBox1.Items[i] );
  end;
  IniFile.Free;
  Action := caFree;
  WriteFormPosition(self);  
end;

procedure TOpenDBDlg.FormDestroy(Sender: TObject);
begin
  OpenDBDlg := nil;
end;

procedure TOpenDBDlg.FormCreate(Sender: TObject);
begin
  bmServerOK := False ;  
end;

procedure TOpenDBDlg.BitBtn1Click(Sender: TObject);
begin
  bmServerOK := True;
  IB_Connection1.Close;
  IB_Connection1.Username := Uppercase(Edit1.Text);
  IB_Connection1.Password := Edit2.Text;
  try
    if (Caption='Add Source Database') then begin
      IB_Connection1.Path := copy(ComboBox1.Text,Pos(':',ComboBox1.Text)+1,255);
      IB_Connection1.Server := copy(ComboBox1.Text,0,Pos(':',ComboBox1.Text)-1);
    end else begin
      IB_Connection1.Path := copy(Edit5.Text,Pos(':',Edit5.Text)+1,255);
      IB_Connection1.Server := copy(Edit5.Text,0,Pos(':',Edit5.Text)-1);
    end;
    IB_Connection1.Connected := True;
    IB_Connection1.Connected := False;
  except
    IB_Connection1.Connected := False;
    bmServerOK := False;
  end;
  if bmServerOK then begin
    MessageDlg(CRLF+'Server name or database name is correct...'+CRLF+'You may save these settings.', mtInformation,
      [mbOK], 0);
  end else begin
    MessageDlg(CRLF+'Server name or database name is incorrect...'+CRLF+'Please correct settings and start again.', mtError,
      [mbOK], 0);
  end;

end;

end.
