unit prefer;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Menus, ExtCtrls, StdCtrls, ComCtrls, WinSvc,
  WinTypes, WinProcs, IniFiles, Buttons,
  Reg, FBReplConst, abcedbtn, abcedtsv, IB_Components, IdMessage,
  IdBaseComponent, IdComponent, IdTCPConnection, IdTCPClient,
  IdMessageClient, IdSMTP, IdSMTPBase, IdExplicitTLSClientServerBase;

type
  TPreferences = class(TForm)
    PageControl1: TPageControl;
    TabSheet2: TTabSheet;
    SpeedButton5: TSpeedButton;
    GroupBox2: TGroupBox;
    CBEvent: TCheckBox;
    Label1: TLabel;
    EInterval: TEdit;
    Label2: TLabel;
    TabSheet3: TTabSheet;
    GroupBox3: TGroupBox;
    Label3: TLabel;
    cbUseEmailAlerts: TCheckBox;
    Edit1: TEdit;
    TabSheet4: TTabSheet;
    GroupBox1: TGroupBox;
    Edit2: TEdit;
    StaticText6: TStaticText;
    StaticText7: TStaticText;
    ReplPath: TEdit;
    StaticText8: TStaticText;
    Edit4: TEdit;
    StaticText9: TStaticText;
    Edit5: TEdit;
    Label4: TLabel;
    Edit6: TEdit;
    Label5: TLabel;
    Edit3: TEdit;
    Label6: TLabel;
    Edit7: TEdit;
    CheckBox1: TCheckBox;
    GroupBox4: TGroupBox;
    Label7: TLabel;
    Edit8: TEdit;
    Label8: TLabel;
    Edit9: TEdit;
    SpeedButton11: TSpeedButton;
    SpeedButton12: TSpeedButton;
    Label9: TLabel;
    abcFileSaveEdit1: TabcFileSaveEdit;
    TabSheet5: TTabSheet;
    GroupBox5: TGroupBox;
    Label10: TLabel;
    CheckBox2: TCheckBox;
    Edit10: TEdit;
    CheckBox3: TCheckBox;
    Label11: TLabel;
    CheckBox4: TCheckBox;
    Label12: TLabel;
    IB_Connection1: TIB_Connection;
    Label13: TLabel;
    Edit11: TEdit;
    Button1: TButton;
    Button2: TButton;
    SpeedButton1: TSpeedButton;
    Button3: TButton;
    SpeedButton2: TSpeedButton;
    Button4: TButton;
    SpeedButton3: TSpeedButton;
    IdSMTP1: TIdSMTP;
    IdMessage1: TIdMessage;
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure FormCreate(Sender: TObject);
    procedure SaveEdits5Click(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure SpeedButton11Click(Sender: TObject);
    procedure SpeedButton12Click(Sender: TObject);
  private
    procedure Save(Sender: TObject);
    { Private declarations }
  public
    { Public declarations }
    ErrorFile : array[0..254] of Char;
  end;

var
  Preferences: TPreferences;

implementation

{$R *.DFM}


procedure TPreferences.FormCreate(Sender: TObject);
var
  slFileName: String;
begin
  Read_Registry;
  PageControl1.ActivePage := TabSheet4;
  Height := 286;
  Width := 370;
  // Database Tab
  Edit2.Text := srReplServer;
  ReplPath.Text := srReplPath;
  Edit4.Text := srReplUser;
  Edit5.Text := srReplPWord;
  // Email Settings Tab
  Edit1.Text := srEmail;
  Edit3.Text := srSMTPLogin;
  Edit6.Text := srSMTPHost;
  Edit7.Text := srSMTPPWord;
  Edit8.Text := IntToStr(irTolerance);
  Edit9.Text := IntToStr(irHeartBeat);
  Edit10.Text := IntToStr(irMaxBlobSize);
  CheckBox2.checked := brVerbose;
  cbUseEmailAlerts.checked := brUseEmailAlerts;
  CheckBox1.checked := brUseSMTPAuthentication;
  CheckBox3.checked := breHeartbeat;
  CheckBox4.checked := brShowStats;
  Edit11.Text := srFromAddress;
  // Options Tab
  CBEvent.Checked := brEvtStr;
  EInterval.Text := srInterval;
  abcFileSaveEdit1.Text := srReplLogFile;
  abcFileSaveEdit1.SaveDialog.FileName := srReplLogFile;
  ReadFormPosition(self);
end;

procedure TPreferences.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
  CanClose := True;
end;

procedure TPreferences.SaveEdits5Click(Sender: TObject);
begin
  Save(self);
  ModalResult := mrOK; //Close;
end;

procedure TPreferences.Save(Sender: TObject);
begin
  // Database Tab
  srReplServer := Edit2.Text;
  srReplPath := ReplPath.Text;
  srReplUser := Edit4.Text;
  srReplPWord := Edit5.Text;
  // Email Settings Tab
  srEmail := Edit1.Text;
  srSMTPHost := Edit6.Text;
  srSMTPLogin := Edit3.Text;
  srSMTPPWord := Edit7.Text;
  irTolerance := StrToInt(Edit8.Text);
  irHeartBeat := StrToInt(Edit9.Text);
  brUseEmailAlerts := cbUseEmailAlerts.checked;
  brUseSMTPAuthentication := CheckBox1.checked;
  // Options Tab
  brEvtStr := CBEvent.Checked;
  srInterval := EInterval.Text;
  srReplLogFile := abcFileSaveEdit1.Text;
  irMaxBlobSize := StrToInt(Edit10.Text);
  brVerbose := CheckBox2.checked;
  breHeartbeat := CheckBox3.checked;
  brShowStats := CheckBox4.checked;
  srFromAddress := Edit11.Text;

//  IBEvent.Interval := StrToInt(srInterval)*1000*60;
  Write_Registry;
end;

procedure TPreferences.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  WriteFormPosition(self);
end;

procedure TPreferences.SpeedButton11Click(Sender: TObject);
var
  bmServerOK: Boolean;
begin
  bmServerOK := True;
  IB_Connection1.Close;
  IB_Connection1.Username := Edit4.Text;
  IB_Connection1.Password := Edit5.Text;
  try
    IB_Connection1.Path := ReplPath.Text;
    IB_Connection1.Server := Edit2.Text;
    IB_Connection1.Connected := True;
    IB_Connection1.Connected := False;
  except
    IB_Connection1.Connected := False;
    bmServerOK := False;
  end;
  if bmServerOK then begin
    MessageDlg(CRLF+'Server name or database name is correct...'+CRLF+'You may save these settings.', mtInformation,
      [mbOK], 0);
  end else begin
    MessageDlg(CRLF+'Server name or database name is incorrect...'+CRLF+'Please correct settings and start again.', mtError,
      [mbOK], 0);
  end;

end;

procedure TPreferences.SpeedButton12Click(Sender: TObject);
begin
  Save(self);
  //**************
  // Send test email
  //**************
  IdSMTP1.Host := srSMTPHost;
  if brUseSMTPAuthentication then begin
    IdSMTP1.Username := srSMTPLogin;
    IdSMTP1.Password := srSMTPPWord;
    IdSMTP1.AuthType := atDefault;
  end else begin
    IdSMTP1.Username := '';
    IdSMTP1.Password := '';
    IdSMTP1.AuthType := atNone;
  end;
  try
    IdSMTP1.Connect;
  except
    on E:Exception do begin
      MessageDlg('Error connecting to SMTP server: '+E.Message, mtError, [mbOK], 0);
    end;
  end;
  // Send test email
  idMessage1.From.Name := srReplServer;
  idMessage1.From.Address := srReplServer+'@'+srFromAddress;
  idMessage1.Sender.Address := srReplServer+'@'+srFromAddress;
  idMessage1.Sender.Name := srReplServer;
  idMessage1.Recipients[0].Name := '';
  idMessage1.Recipients[0].Address := srEmail;
  idMessage1.ReplyTo[0].Name := srReplServer;
  idMessage1.ReplyTo[0].Address := srReplServer+'@'+srFromAddress;
  idMessage1.Subject := 'FBReplicator Test Message';
  idMessage1.Body.Clear;
  idMessage1.Body.Add('<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 3.2//EN">');
  idMessage1.Body.Add('<html>');
  idMessage1.Body.Add('<head>');
  idMessage1.Body.Add('<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=iso-8859-1">');
  idMessage1.Body.Add('<title>FBReplicator Emailer</title>');
  idMessage1.Body.Add('</head>');
  idMessage1.Body.Add('<body>');
  idMessage1.Body.Add('<table width="100%" cellspacing=0 cellpadding=3 border=0>');
  idMessage1.Body.Add('<TR>');
  idMessage1.Body.Add('<TD width=32 background=http://www.meta.com.au/images/stories/fbheader_tile.gif>');
  idMessage1.Body.Add('<IMG alt=meta src="http://www.meta.com.au/images/stories/fbrepllogo.gif"></TD>');
  idMessage1.Body.Add('<TD background=http://www.meta.com.au/images/stories/fbheader_tile.gif><font face="Tahoma" size="2"><b>FBReplicator</b></font><br><font face="Tahoma" size="1">This email has been server generated, please do not reply.</font></TD>');
  idMessage1.Body.Add('</TR></table>');
  idMessage1.Body.Add('<p><font face="Tahoma" size="2">'+DateTimeToStr(Now)+': Test email from FBReplicator Manager Utility at <b>'+srReplServer+'</b> via SMTPHost: <b>'+srSMTPHost+'</b></font></p>');
  idMessage1.Body.Add('<p><font face="Tahoma" size="1">This email has been sent by the FBReplicator Manager Utility to test email connections.');
  idMessage1.Body.Add('<br><b>Warning</b>: This computer program is produced as shareware. ');
  idMessage1.Body.Add('The source can be copied, freely distributed, modified, sold or anything else that you wish to do with it. ');
  idMessage1.Body.Add('Certain parts, however, are copyright and it is recommended that appropriate recognition of the copyright holders be displayed somewhere in the distribution.</font>');
  idMessage1.Body.Add('</table>');
  idMessage1.Body.Add('</body>');
  idMessage1.Body.Add('</html>');
  try
    IdSMTP1.Send(idMessage1);
    MessageDlg('Test email sent to '+srEmail+' via '+srSMTPHost, mtConfirmation, [mbOK], 0);
  except
    on E:Exception do begin
      MessageDlg('Error sending error email message: '+E.Message, mtError, [mbOK], 0);
      //inc(exceptCount);
    end;
  end;
  IdSMTP1.Disconnect;
end;

initialization

end.
