unit rmgr1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls, Buttons, ExtCtrls, OpenDB, RmgrSQL,
  DualDlg, DBEdit, IniFiles, Menus, IB_Components, IBODataset, DB, IB_Session,
  Grids, DBGrids, Lloyd, ActnList, ActnPopupCtrl, XPStyleActnCtrls,
  ActnMan, ActnCtrls, ToolWin, ActnMenus, DBCtrls, Reg, FBReplConst, Mask,
  StdStyleActnCtrls, BandActn;

const
  VERSION = 'FBRM 4.0';

  CHANGES_INSERT
    = 'INSERT INTO CHANGES(TABLEKEY,TABLENAME,OP,LOC_ID)';
  LOCATION_ID_FIELD
    = 'LOC_ID';
  LOCATION_SELECT
    = 'FROM REPL_TABLES WHERE TABLENAME=';

  IB_SMALLINT = 7;
  IB_INTEGER  = 8;
  IB_BIGINTEGER  = 16;

type
  TReplManagerShell = class(TForm)
    Panel1: TPanel;
    Panel2: TPanel;
    Edit1: TEdit;
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    TabSheet3: TTabSheet;
    Label2: TLabel;
    Label3: TLabel;
    SaveDialog1: TSaveDialog;
    Label6: TLabel;
    TabSheet4: TTabSheet;
    EventMemo: TMemo;
    CheckBox1: TCheckBox;
    EvntCancelBtn: TButton;
    EvntSaveBtn: TButton;
    Button5: TButton;
    BtnDBOpen: TButton;
    BtnDBClose: TButton;
    SourceDB: TIBODatabase;
    ReplDB: TIBODatabase;
    QuerySource: TIBOQuery;
    QueryRepl: TIBOQuery;
    IBOQuerySources: TIBOQuery;
    dsIBOQuerySources: TDataSource;
    IBOQuerySourcesID: TIntegerField;
    IBOQuerySourcesSOURCE_SERVER: TStringField;
    IBOQuerySourcesSOURCE_PATH: TStringField;
    IBOQuerySourcesUSERNAME: TStringField;
    IBOQuerySourcesPASSWD: TStringField;
    ActionManager1: TActionManager;
    PopupActionBarEx1: TPopupActionBarEx;
    ActionList1: TActionList;
    acnOpenDB: TAction;
    acnCloseDB: TAction;
    acnExit: TAction;
    acnAddSource: TAction;
    acnPreferences: TAction;
    acnAbout: TAction;
    acnEditSource: TAction;
    acnRefreshSourceTables: TAction;
    acnApplyTriggers: TAction;
    acnApplyColumnDefinitions: TAction;
    acnAddTargetDB: TAction;
    acnEditTargetDB: TAction;
    acnDeleteTargetDB: TAction;
    acnEditColumnDefs: TAction;
    acnDeleteSource: TAction;
    Panel4: TPanel;
    Panel5: TPanel;
    Panel6: TPanel;
    Label8: TLabel;
    TableListBox1: TListBox;
    Panel7: TPanel;
    Panel8: TPanel;
    Panel10: TPanel;
    Panel11: TPanel;
    StaticText2: TStaticText;
    StaticText4: TStaticText;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    Panel13: TPanel;
    Panel14: TPanel;
    StaticText1: TStaticText;
    Panel15: TPanel;
    StaticText3: TStaticText;
    BitBtn3: TBitBtn;
    BitBtn4: TBitBtn;
    BitBtn5: TBitBtn;
    BitBtn6: TBitBtn;
    BitBtn7: TBitBtn;
    BitBtn8: TBitBtn;
    BitBtn9: TBitBtn;
    BitBtn10: TBitBtn;
    IBOQuerySourcesREPLUSER: TStringField;
    IBOQuerySourcesREPLPASSWD: TStringField;
    Panel16: TPanel;
    DBGrid1: TDBGrid;
    GroupBox1: TGroupBox;
    DBEdit1: TDBEdit;
    Label5: TLabel;
    Label7: TLabel;
    DBEdit2: TDBEdit;
    GroupBox2: TGroupBox;
    Label12: TLabel;
    Label13: TLabel;
    DBEdit3: TDBEdit;
    DBEdit4: TDBEdit;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    ActionMainMenuBar1: TActionMainMenuBar;
    OpenReplicationDatabase1: TMenuItem;
    CloseReplicationDatabase1: TMenuItem;
    Preferences1: TMenuItem;
    Exit1: TMenuItem;
    N1: TMenuItem;
    N2: TMenuItem;
    Edit2: TMenuItem;
    RefreshSourceTables1: TMenuItem;
    BitBtn11: TBitBtn;
    BitBtn12: TBitBtn;
    Help1: TMenuItem;
    About1: TMenuItem;
    ActionToolBar1: TActionToolBar;
    Add1: TMenuItem;
    DeleteSourceDatabase1: TMenuItem;
    N3: TMenuItem;
    argets1: TMenuItem;
    Definitions1: TMenuItem;
    ColumnDefinitions1: TMenuItem;
    ApplyColumnDefinitions1: TMenuItem;
    N4: TMenuItem;
    AddTargetDatabase2: TMenuItem;
    argetDataBase1: TMenuItem;
    DeleteTargetDataBase2: TMenuItem;
    EditTriggerTemplate1: TMenuItem;
    SourceDetails1: TMenuItem;
    StaticText5: TStaticText;
    PnlColumns: TPanel;
    PnlAvailableCols: TPanel;
    Panel19: TPanel;
    ColSrcList: TListBox;
    ColDstList: TListBox;
    Panel20: TPanel;
    Label14: TLabel;
    Panel21: TPanel;
    Label17: TLabel;
    Splitter1: TSplitter;
    Panel3: TPanel;
    Panel12: TPanel;
    Label4: TLabel;
    TriggerMemo: TMemo;
    PnlDBs: TPanel;
    PnlAvailDBs: TPanel;
    PnlTargetDBs: TPanel;
    Splitter2: TSplitter;
    Panel17: TPanel;
    Label1: TLabel;
    Panel18: TPanel;
    Label9: TLabel;
    DBSrcList: TListBox;
    DBDstList: TListBox;
    Splitter3: TSplitter;
    procedure BtnDBOpenClick(Sender: TObject);
    procedure BtnDBCloseClick(Sender: TObject);
    procedure ColCancelBtnClick(Sender: TObject);
    procedure ColSaveBtnClick(Sender: TObject);
    procedure TrigSaveBtnClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure DbModBtnClick(Sender: TObject);
    procedure DbCancelBtnClick(Sender: TObject);
    procedure DbSaveBtnClick(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
    procedure EvntSaveBtnClick(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure acnExitExecute(Sender: TObject);
    procedure acnAboutExecute(Sender: TObject);
    procedure acnPreferencesExecute(Sender: TObject);
    procedure acnOpenDBExecute(Sender: TObject);
    procedure acnCloseDBExecute(Sender: TObject);
    procedure acnDeleteSourceExecute(Sender: TObject);
    procedure acnRefreshSourceTablesExecute(Sender: TObject);
    procedure acnEditColumnDefsExecute(Sender: TObject);
    procedure acnEditSourceExecute(Sender: TObject);
    procedure TableListBox1DblClick(Sender: TObject);
    procedure ActionMainMenuBar1ExitMenuLoop(Sender: TCustomActionMenuBar;
      Cancelled: Boolean);
    procedure ActionMainMenuBar1Popup(Sender: TObject;
      Item: TCustomActionControl);
    procedure IBOQuerySourcesAfterScroll(DataSet: TDataSet);
    procedure acnAddSourceExecute(Sender: TObject);
    procedure BitBtn3Click(Sender: TObject);
    procedure BitBtn4Click(Sender: TObject);
    procedure BitBtn5Click(Sender: TObject);
    procedure IBOQuerySourcesNewRecord(DataSet: TDataSet);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure PnlColumnsResize(Sender: TObject);
    procedure PnlDBsResize(Sender: TObject);
  private
    { Private declarations }
    FNewMenuActions: TList;
    procedure LoadMenu(ActionList: TCustomActionList;
      Clients: TActionClients; AMenu: TMenuItem; SetActionList: Boolean = True);
    procedure UpdateActionMainMenuBar(Menu: TMenu);
    procedure DispErrorMsg( E : EIB_ISCError );
    function CountReplTables: Integer;
    procedure SetupReplTables;
    function GetWorkingPath: string;
    procedure InitDstFields(TableName: string);
    procedure InitSrcFields(TableName: String );
    procedure InitTableList;
    procedure InitDbList(TableName: string);
    procedure StoreStmt( Stmt : TStringList; TableName : String; Op : Char);
    procedure BuildTriggers( Fields: TStrings; Table: string; Path: string);
    procedure AddTrigger( Fields : TStrings; Table : string; Op : string;
      TrigTemp: TStringList );
    procedure DropTrigger( Table : string; Op : string; TrigTemp: TStringList );
    procedure AddEventTrigger;
    procedure DropEventTrigger;
    function VerifyIntegerCol(ColName: String; TableName: String): boolean;
    function getFirstSelected( List: TCustomListBox ): Integer;
    procedure GetTrigTemplate( var TrigTemp: TStringList );
    function GetTrigName(TrigLine: string): string;
    function CheckTrigExists( TrigName: string ): boolean;
    function ChangeTrigToAlter( TrigLine: string): string;
    procedure ApplyTrigToDB( TrigLines: TStrings );
    procedure SaveSourceDB(DBServer, DBPath: string; UserName: string; Password: string; RUserName: string; RPassword: string);
    procedure EditSourceDB(DBServer, DBPath, UserName, Password, RUserName, RPassword: String; ID: Integer);
    procedure BuildMemoryTriggers(Table, Path: string);
    procedure DropMemoryTrigger(Table, Op: string; TrigTemp: TStringList);
  public
    { Public declarations }
    ReplTable : string[32];
    ReplFields : TStrings;
    ADBPath: string[200];
    OUserName: string[50];
    OPassword: string[50];
    RUserName: string[50];
    RPassword: string[50];

  end;

var
  ReplManagerShell: TReplManagerShell;
  TableList : TStringList;
  FieldList : TStringList;
  DeleteTriggersList: TStringList;
  DBList: TStringList;
  UserName: string[50];
  ReplUserName: string[50];
  WorkingPath: string[255];

implementation

uses DelDb, AppTrig, DBSetup, ImagesDM, About, prefer;

{$R *.DFM}
type

{ TABMenuAction -
    This class is a special ActionBand menu action that stores the TMenuItem
    that it is associated with so that if it is executed it can actually call
    the TMenuItem.Click method simulating an actual click on the TMenuItem
    itself.  }

  TABMenuAction = class(TCustomAction)
  private
    FMenuItem: TMenuItem;
  protected
    procedure Notification(AComponent: TComponent; Operation: TOperation); override;
  public
    destructor Destroy; override;
    procedure ExecuteTarget(Target: TObject); override;
    function HandlesTarget(Target: TObject): Boolean; override;
  end;

destructor TABMenuAction.Destroy;
begin
  if Assigned(FMenuItem) then
    FMenuItem.RemoveFreeNotification(Self);
  inherited;
end;

procedure TABMenuAction.Notification(AComponent: TComponent; Operation: TOperation);
begin
  if (Operation = opRemove) and (AComponent = FMenuItem) then
    FMenuItem := nil;
end;

procedure TABMenuAction.ExecuteTarget(Target: TObject);
begin
  if Assigned(FMenuItem) then
    FMenuItem.Click;
end;

function TABMenuAction.HandlesTarget(Target: TObject): Boolean;
begin
  Result := True;
end;


procedure TReplManagerShell.DispErrorMsg( E: EIB_ISCError );
//var
//  i: Integer;
//  S : string[100];
begin
//  for i := 0 to E.ErrorCount-1 do
//  begin
//    if( E.Errors[i].NativeError <> 0 ) then
      MessageDlg(E.ErrorMessage.Text, mtInformation, [mbOK], 0 );
//  end;
end;

procedure TReplManagerShell.BtnDBOpenClick(Sender: TObject);
var
  AliasParams: TStringList;
  msgmessage: String;
begin
  { Prompt for db to open }
  if (OpenDBDlg=nil) then
    OpenDBDlg := TOpenDBDlg.Create(self);
  ReadFormPosition(OpenDBDlg);
  with OpenDBDlg do begin
    ComboBox1.Visible := True;
    Edit5.Visible := False;
  end;
  if( OpenDBDlg.ShowModal = mrOK ) then begin
    Edit1.Text := ADBPath;
    if( ADBPath <> '') then begin
      { open the db }
      with SourceDB do begin
        Close;
        Server := copy(ADBPath,0,Pos(':',ADBPath)-1);
        Path := copy(ADBPath,Pos(':',ADBPath)+1,255);
        Username := OUserName;
        Password := OPassword;
        try
          Open;
        except
          on E1: EIB_ISCError do begin
            MessageDlg('Cannot open database:'+#13+#10+ADBPath+#13+#10+E1.ErrorMessage.Text, mtError, [mbOK], 0);
          end;
        end;
      end;
      { Verify the selected db has the necessary replication tables }
      if( CountReplTables > 0 ) then begin
        SaveSourceDB(SourceDB.Server, SourceDB.Path, OUserName, OPassword, RUsername, RPassword );
        UserName := OUserName;
        InitTableList;
        TableListBox1.ItemIndex := 0;
        TableListBox1DblClick(self);
      end else begin
        msgmessage := 'Source database:'+#13+#10+ADBPath;
        msgMessage := msgmessage +#13+#10+'is not setup for replication.'+#13+#10+''+#13+#10+'Do you wish to setup this source database for replication?';
        msgMessage := msgmessage +#13+#10+#13+#10+'This process will add the CHANGES and REPL_TABLES tables to the source.';
        if (MessageDlg(msgmessage, mtConfirmation, [mbOK,mbCancel], 0)=mrOK) then begin
          SetupReplTables;
          SaveSourceDB(SourceDB.Server, SourceDB.Path, OUserName, OPassword, RUserName, RPassword );
          UserName := OUserName;
          InitTableList;
          TableListBox1.ItemIndex := 0;
        end else
          SourceDB.Close;
      end;
    end;
  end;
  IBOQuerySources.Refresh;
end;

procedure TReplManagerShell.SetupReplTables;
var
  progress: String;
begin
  SourceDB.Commit;
  with QuerySource do begin
    try
      Close;
      SQL.Clear;
      SQL.Add('CREATE TABLE CHANGES(');
      SQL.Add('CHANGECODE BIGINT NOT NULL,');
      SQL.Add('TABLENAME VARCHAR(32) NOT NULL,');
      SQL.Add('TABLEKEY BIGINT NOT NULL,');
      SQL.Add('OP CHAR(1) NOT NULL,');
      SQL.Add('LOC_ID INTEGER NOT NULL)');
      SourceDB.StartTransaction;
      ExecSQL;
      SourceDB.Commit;
      progress := 'CHANGES table created';

      SQL.Clear;
      SQL.Add('ALTER TABLE CHANGES ADD CONSTRAINT PK_CHANGES PRIMARY KEY (CHANGECODE)');
      SourceDB.StartTransaction;
      ExecSQL;
      SourceDB.Commit;
      progress := progress+#13+#10+'CHANGES table PK added';

      SQL.Clear;
      SQL.Add('CREATE INDEX CHANGES_LOC_ID ON CHANGES (LOC_ID)');
      SourceDB.StartTransaction;
      ExecSQL;
      SourceDB.Commit;
      progress := progress+#13+#10+'CHANGES(LOC_ID) table index added';

      SQL.Clear;
      SQL.Add('CREATE INDEX CHANGES_TABLENAME ON CHANGES (TABLENAME)');
      SourceDB.StartTransaction;
      ExecSQL;
      SourceDB.Commit;
      progress := progress+#13+#10+'CHANGES(TABLENAME) index added';

      SQL.Clear;
      SQL.Add('CREATE GENERATOR GEN_CHANGECODE');
      ExecSQL;
      SourceDB.Commit;
      progress := progress+#13+#10+'GEN_CHANGECODE generator added';

      SQL.Clear;
      SQL.Add('CREATE TRIGGER INSERT_CHANGES FOR CHANGES');
      SQL.Add('BEFORE INSERT AS');
      SQL.Add('BEGIN');
      SQL.Add('  NEW.CHANGECODE = GEN_ID( GEN_CHANGECODE, 1 );');
      SQL.Add('END');
      ExecSQL;
      SourceDB.Commit;
      progress := progress+#13+#10+'CHANGES PK trigger added';

      SQL.Clear;
      SQL.Add('GRANT SELECT, INSERT ON CHANGES TO PUBLIC');
      SourceDB.StartTransaction;
      ExecSQL;
      SourceDB.Commit;
      progress := progress+#13+#10+'CHANGES table permissions added';

      SQL.Clear;
      SQL.Add('CREATE TABLE REPL_TABLES(');
      SQL.Add('TABLENAME VARCHAR(32) NOT NULL,');
      SQL.Add('LOC_ID INTEGER NOT NULL)');
      ExecSQL;
      SourceDB.Commit;
      progress := progress+#13+#10+'REPL_TABLES table created';

      SQL.Clear;
      SQL.Add('GRANT SELECT ON REPL_TABLES TO PUBLIC');
      ExecSQL;
      SourceDB.Commit;
      progress := progress+#13+#10+'REPL_TABLES permissions added';

      MessageDlg('Modifications carried out:'+#13+#10+progress, mtInformation, [mbOK], 0);
    except
      on E1: EIB_ISCError do begin
        MessageDlg('Cannot Setup DB for Replication!'+#13+#10+'Rolling back last attempted change.'+#13+#10+E1.ErrorMessage.Text, mtError, [mbOK], 0);
        if( SourceDB.inTransaction ) then
          SourceDB.Rollback;
      end;
    end;
  end;
end;

procedure TReplManagerShell.SaveSourceDB(DBServer, DBPath: string; UserName: string; Password: string; RUserName: String; RPassword: String);
begin
  ReplDB.Commit;
  with QueryRepl do begin
    Close;
    SQL.Clear;
    SQL.Add('INSERT INTO SOURCE_LOCATION( SOURCE_SERVER, SOURCE_PATH, USERNAME, PASSWD, REPLUSER, REPLPASSWD )');
    SQL.Add('VALUES( :SS, :SP, :U, :P, :RN, :RP )');
    ParamByName('SS').AsString := DBServer;
    ParamByName('SP').AsString := DBPath;
    ParamByName('U').AsString := UserName;
    ParamByName('P').AsString := Password;
    ParamByName('RN').AsString := RUserName;
    ParamByName('RP').AsString := RPassword;
    ExecSQL;
    ReplDB.Commit;
  end;
end;

procedure TReplManagerShell.EditSourceDB(DBServer, DBPath: string; UserName: string; Password: string; RUserName: String; RPassword: String; ID: Integer);
begin
  ReplDB.Commit;
  with QueryRepl do begin
    Close;
    SQL.Clear;
    SQL.Add('UPDATE SOURCE_LOCATION SET SOURCE_SERVER=:SS, SOURCE_PATH=:SP, USERNAME=:U, PASSWD=:P, REPLUSER=:RN, REPLPASSWD=:RP');
    SQL.Add('WHERE ID=:ID');
    ParamByName('SS').AsString := DBServer;
    ParamByName('SP').AsString := DBPath;
    ParamByName('U').AsString := UserName;
    ParamByName('P').AsString := Password;
    ParamByName('RN').AsString := RUserName;
    ParamByName('RP').AsString := RPassword;
    ParamByName('ID').AsInteger := ID;
    ExecSQL;
    ReplDB.Commit;
  end;
end;

function TReplManagerShell.CountReplTables: Integer;
var
  Count: Integer;
begin
  Count := 0;
  { Select the special replication table names from the metadata }
  with QuerySource do begin
    Close;
    SQL.Clear;
    SQL.Add('SELECT RDB$RELATION_NAME FROM');
    SQL.Add('RDB$RELATIONS WHERE');
    SQL.Add('RDB$RELATION_NAME = ''CHANGES''');
    SQL.Add('OR RDB$RELATION_NAME = ''REPL_TABLES''');

    SourceDB.Commit;
    SourceDB.StartTransaction;
    QuerySource.Open;
    First;
    while not QuerySource.EOF do begin
      QuerySource.Next;
      inc(Count);
    end;
    QuerySource.Close;
    SourceDB.Commit;
  end;

  CountReplTables := Count;
end;

procedure TReplManagerShell.InitTableList;
begin
  { Set Up Table List Box }
  TableList.Clear;
  with QuerySource do begin
    Close;
    SQL.Clear;
    SQL.Add('SELECT RDB$RELATION_NAME FROM');
    SQL.Add('RDB$RELATIONS WHERE');
    SQL.Add('RDB$SYSTEM_FLAG <> 1');
    SQL.Add('AND RDB$VIEW_BLR IS NULL');
    SQL.Add('AND RDB$RELATION_NAME <> ''CHANGES''');
    SQL.Add('AND RDB$RELATION_NAME <> ''REPL_TABLES''');
    SQL.Add('ORDER BY RDB$RELATION_NAME');
    SourceDB.Commit;
    SourceDB.StartTransaction;
    Open;
  end;
  while not QuerySource.EOF do begin
    TableList.Add(QuerySource.Fields[0].AsString);
    QuerySource.Next;
  end;
  QuerySource.Close;
  SourceDB.Commit;
  TableListBox1.Items := TableList;
  TableListBox1.Sorted := True;
end;

procedure TReplManagerShell.InitSrcFields( TableName: string );
var
  i: Integer;
begin
  { Set Up Field List Box }
  FieldList.Clear;
  with QuerySource do begin
    Close;
    SQL.Clear;
    { Get the fields that are not computed and not arrays}
    SQL.Add('SELECT RF.RDB$FIELD_NAME FROM');
    SQL.Add('RDB$RELATION_FIELDS RF LEFT JOIN RDB$FIELDS F');
    SQL.Add('ON RF.RDB$FIELD_SOURCE = F.RDB$FIELD_NAME WHERE');
    SQL.Add('RDB$RELATION_NAME = :TABLENAME');
    SQL.Add('AND F.RDB$COMPUTED_BLR IS NULL');
    SQL.Add('AND F.RDB$DIMENSIONS IS NULL');

    {Don't select those fields currently selected }
    for i := 0 to ColDstList.Items.Count - 1 do begin
      SQL.Add('AND RF.RDB$FIELD_NAME <> '''+ColDstList.Items[i]+'''');
    end;

    SQL.Add('ORDER BY RF.RDB$FIELD_NAME');
    ParamByName('TABLENAME').AsString := TableName;
    SourceDB.Commit;
    SourceDB.StartTransaction;
    Open;
    First;
  end;
  while not QuerySource.EOF do begin
    FieldList.Add(QuerySource.Fields[0].AsString);
    QuerySource.Next;
  end;
  QuerySource.Close;
  SourceDB.Commit;

  ColSrcList.Clear;
  ColSrcList.Items := FieldList;
  ColSrcList.Sorted := True;
end;

procedure TReplManagerShell.InitDstFields(TableName: string);
var
  stmt: string[255];
  field: string[32];
  StartPos, CommaPos, EndPos: Integer;
  SelectFound, FromFound: boolean;
begin
  ColDstList.Clear;
  ReplDB.Commit;
  with QueryRepl do begin
    Close;
    SQL.Clear;
    { Get the fields including in any existing REPLDEFS entry}
    SQL.Add('SELECT SQLSTMT FROM REPLDEFS WHERE');
    SQL.Add('TABLENAME = :TABLENAME');
    SQL.Add('AND OPTYPE = ''S''');
    SQL.Add('ORDER BY MORE');
    ParamByName('TABLENAME').AsString := TableName;
    ReplDB.StartTransaction;
    Open;
    SelectFound := False;
    FromFound := False;
    while ((not EOF) and (not FromFound)) do begin
      { Parse out the column names from the SQLSTMT }
      stmt := Fields[0].AsString;
      if( not SelectFound ) then begin
        { remove select keyword + blank }
        System.Delete(stmt, 1, 7);
        SelectFound := True;
      end;
      { stop either at the FROM or end of line }
      EndPos := Pos(' FROM',stmt);
      if( EndPos = 0 ) then
        EndPos := length(stmt)
      else begin
        FromFound := True;
        dec(EndPos);
        //dec(EndPos);
      end;
      if (Pos(',',stmt)=1) then
        System.Delete(stmt,1,1);
      while EndPos > 0 do begin
        CommaPos := Pos(',',stmt);
        if(CommaPos = 0) then
          CommaPos := EndPos+1;
        field := Copy(stmt, 1, CommaPos - 1 );
        ColDstList.Items.Add(field);

        System.Delete(stmt, 1, CommaPos );
        EndPos := EndPos - CommaPos;
      end;

      if( not FromFound ) then
        Next;
    end;
    ReplDB.Commit;
    Close;
  end;
end;

procedure TReplManagerShell.InitDbList(TableName: string);
var
  i: Integer;
  DstDbIds: TStringList;
  DstFound: boolean;
begin
  DstDbIds := TStringList.Create;
  DbDstList.Clear;

  with QuerySource do begin
    Close;
    SQL.Clear;
    SQL.Add('SELECT LOC_ID FROM REPL_TABLES');
    SQL.Add('WHERE TABLENAME = :TABLENAME');
    SQL.Add('ORDER BY LOC_ID');
    ParamByName('TABLENAME').AsString := TableName;
    ReplDB.Commit;
    SourceDB.StartTransaction;
    Open;
    First;
    while not QuerySource.EOF do begin
      DstDbIds.Add(Fields[0].AsString);
      Next;
    end;
    Close;
  end;
  SourceDB.Commit;

  DbList.Clear;
  with QueryRepl do begin
    Close;
    SQL.Clear;
    SQL.Add('SELECT LOC_ID,LOC_PATH FROM LOCATIONS');
    SQL.Add('ORDER BY LOC_ID');
    ReplDB.StartTransaction;
    Open;
    First;
    while not EOF do begin
      DstFound := False;
      for i := 0 to DstDbIds.Count-1 do
      begin
        if( CompareStr(DstDbIds[i],Fields[0].AsString) = 0 ) then
        begin
          DstFound := True;
          Break;
        end;
      end;

      if( DstFound ) then
        DbDstList.Items.Add(Fields[0].AsString + ',' + Fields[1].AsString)
      else
        DbList.Add(Fields[0].AsString + ',' + Fields[1].AsString);

      Next;
    end;
    Close;
  end;
  ReplDB.Commit;
  DbSrcList.Clear;
  DbSrcList.Items := DbList;
  DbSrcList.Sorted := True;
  DstDbIds.Free;
end;

procedure TReplManagerShell.BtnDBCloseClick(Sender: TObject);
begin
  SourceDB.Close;
end;

procedure TReplManagerShell.ColCancelBtnClick(Sender: TObject);
begin
  ColDstList.Clear;
  ColSrcList.Clear;
  TableListBox1.ItemIndex := 0;
  TriggerMemo.Clear;
end;

procedure TReplManagerShell.ColSaveBtnClick(Sender: TObject);
var
  Stmt :  TStringList;
  Index : Integer;
begin
  if MessageDlg('Apply column definitions? All previous definitions will be '+#13+#10+'removed and replaced. If no columns are listed, '+#13+#10+'there will be no impact from this action.', mtConfirmation, [mbOK,mbCancel], 0)=mrOK then begin
    Stmt := TStringList.Create;
    Index := TableListBox1.ItemIndex;
    ReplFields := ColDstList.Items;

    RmgrSQL.BuildSelect( ReplFields, ReplTable, Stmt );
    StoreStmt( Stmt, TableListBox1.Items.Strings[Index], 'S');
    Stmt.Clear;

    RmgrSQL.BuildInsert( ColDstList.Items, TableListBox1.Items.Strings[ Index ], Stmt );
    StoreStmt( Stmt, TableListBox1.Items.Strings[Index], 'I');
    Stmt.Clear;

    RmgrSQL.BuildUpdate( ColDstList.Items, TableListBox1.Items.Strings[ Index ], Stmt );
    StoreStmt( Stmt, TableListBox1.Items.Strings[Index], 'U');
    Stmt.Clear;

    RmgrSQL.BuildDelete( ColDstList.Items, TableListBox1.Items.Strings[ Index ], Stmt );
    StoreStmt( Stmt, TableListBox1.Items.Strings[Index], 'D');
    Stmt.Free;

    BuildTriggers( ColDstList.Items, ReplTable, IBOQuerySourcesSOURCE_SERVER.AsString+':'+IBOQuerySourcesSOURCE_PATH.AsString );
    BitBtn3Click(self);
  end;
end;

procedure TReplManagerShell.StoreStmt ( Stmt : TStringList; TableName : string; Op : Char);
var
  More, I : SmallInt;
begin
  ReplDB.Commit;
  with QueryRepl do begin
    SQL.Clear;
    SQL.Add('DELETE FROM REPLDEFS ');
    SQL.Add('WHERE TABLENAME = :TABLENAME AND');
    SQL.Add('OPTYPE = :OP');

    ParamByName('TABLENAME').AsString := TableName;
    ParamByName('OP').AsString := Op;

    ReplDB.StartTransaction;
    ExecSQL;

    if( Stmt.Count > 1 ) then
      More := 1
    else
      More := 0;

      SQL.Clear;
      SQL.Add('INSERT INTO REPLDEFS(');
      SQL.Add('TABLENAME, OPTYPE, SQLSTMT, MORE, FK_SOURCE) VALUES (');
      SQL.Add(':TABLENAME, :OPERATION, :STMT, :MORE, :FK_SOURCE)');
    for I := 0 to (Stmt.Count - 1) do begin
      ParamByName('TABLENAME').AsString := TableName;
      ParamByName('OPERATION').AsString := Op;
      ParamByName('STMT').AsString := Stmt[I];
      ParamByName('MORE').AsInteger := More + I;
      ParamByName('FK_SOURCE').AsString := IBOQuerySourcesID.AsString;

      ExecSQL;
    end;
  end;

  ReplDB.Commit;
end;

procedure TReplManagerShell.BuildTriggers( Fields : TStrings; Table : string; Path : string);
var
  Op : string[6];
  TrigTemplate : TStringList;
begin
  TrigTemplate := TStringList.Create;
  GetTrigTemplate( TrigTemplate );

  With TriggerMemo do
  begin
    Clear;

    Lines.Add('CONNECT "' + Path + '";');
    Lines.Add('');

    Lines.Add('SET TERM ^^;');
    Lines.Add('');

    if( Fields.Count > 0 ) then begin
      Op := 'DELETE';
      AddTrigger( Fields, Table, Op, TrigTemplate );
      Lines.Add('^^');

      Op := 'INSERT';
      AddTrigger( Fields, Table, Op, TrigTemplate );
      Lines.Add('^^');

      Op := 'UPDATE';
      AddTrigger( Fields, Table, Op, TrigTemplate );
      Lines.Add('^^');
    end else begin
      Op := 'INSERT';
      DropTrigger( Table, Op, TrigTemplate );
      Lines.Add('^^');

      Op := 'UPDATE';
      DropTrigger( Table, Op, TrigTemplate );
      Lines.Add('^^');

      Op := 'DELETE';
      DropTrigger( Table, Op, TrigTemplate );
      Lines.Add('^^');
    end;

    Lines.Add('SET TERM ;^^');
  end;
  TrigTemplate.Free;
end;

procedure TReplManagerShell.BuildMemoryTriggers( Table : string; Path : string);
var
  Op : string[6];
  TrigTemplate : TStringList;
begin
  TrigTemplate := TStringList.Create;
  GetTrigTemplate( TrigTemplate );

  With DeleteTriggersList do
  begin
    Clear;

    Add('CONNECT "' + Path + '";');
    Add('');

    Add('SET TERM ^^;');
    Add('');

    Op := 'INSERT';
    DropMemoryTrigger( Table, Op, TrigTemplate );
    Add('^^');

    Op := 'UPDATE';
    DropMemoryTrigger( Table, Op, TrigTemplate );
    Add('^^');

    Op := 'DELETE';
    DropMemoryTrigger( Table, Op, TrigTemplate );
    Add('^^');

    Add('SET TERM ;^^');
  end;
  TrigTemplate.Free;
end;

procedure TReplManagerShell.DropMemoryTrigger( Table : string; Op : string; TrigTemp: TStringList );
var
  OutTrig : string[80];
  TempLine: string[80];
  i, StartPos, EndPos: Integer;
  Token: string[32];
  TrigName: string[32];
begin
  for i := 0 to TrigTemp.Count-1 do begin
    TempLine := TrigTemp[i];
    StartPos := Pos('@@',TempLine);
    OutTrig := '';
    while( StartPos > 0 ) do begin
      OutTrig := OutTrig + Copy(TempLine, 1, StartPos - 1);
      Delete(TempLine,1,StartPos+1);
      EndPos := Pos('@@',TempLine);
      Token := Copy( TempLine, 1, EndPos-1);
      Delete(TempLine,1,EndPos+1);
      StartPos := Pos('@@',TempLine);

      if( CompareText(Token,'table') = 0 ) then
        OutTrig := OutTrig + Table
      else if( CompareText(Token,'action') = 0 ) then
        OutTrig := OutTrig + Op
      else if( CompareText(Token,'op') = 0 ) then
        OutTrig := OutTrig + Op[1]
      else if( CompareText(Token,'username') = 0 ) then
        OutTrig := OutTrig + ReplUserName;
    end;

    OutTrig := OutTrig + TempLine;

    if(Pos('CREATE',AnsiUpperCase(OutTrig)) > 0 ) then
    begin
      DeleteTriggersList.Add('DROP TRIGGER '+ GetTrigName(OutTrig));
      break;
    end;
  end;
end;

procedure TReplManagerShell.GetTrigTemplate( var TrigTemp: TStringList );
var
  F: TextFile;
  S: string;
begin
  TrigTemp.Clear;
  AssignFile(F, ExtractFilePath(Application.EXEName)+'repltrig.sql');
  if FileExists(ExtractFilePath(Application.EXEName)+'repltrig.sql') then begin
    Reset(F);
    Readln(F, S);

    while( not Eof(F) ) do
    begin
      if(length(S) > 0) then
      begin
        if(S[1] <> '#') then
        begin
          TrigTemp.Add(S);
        end;
      end;

      Readln(F,S);
    end;
    CloseFile(F);
  end else
    MessageDlg('File ''repltrig.sql'' does not exist.'+#13+#10+'Please place template trigger file in execution directory.', mtConfirmation, [mbOK], 0)    
end;

procedure TReplManagerShell.AddTrigger( Fields: TStrings; Table: string; Op: string; TrigTemp: TStringList );
var
  OutTrig : string[80];
  TempLine: string[80];
  context : string[4];
  i, StartPos, EndPos: Integer;
  Token: string[32];
  TrigName: string[32];
begin
  if( Op = 'DELETE' ) then
    context := 'OLD'
  else
    context := 'NEW';

  for i := 0 to TrigTemp.Count-1 do begin
    TempLine := TrigTemp[i];
    StartPos := Pos('@@',TempLine);
    OutTrig := '';
    while( StartPos > 0 ) do begin
      OutTrig := OutTrig + Copy(TempLine, 1, StartPos - 1);
      Delete(TempLine,1,StartPos+1);
      EndPos := Pos('@@',TempLine);
      Token := Copy( TempLine, 1, EndPos-1);
      Delete(TempLine,1,EndPos+1);
      StartPos := Pos('@@',TempLine);

      if( CompareText(Token,'table') = 0 ) then
        OutTrig := OutTrig + Table
      else if( CompareText(Token,'action') = 0 ) then
        OutTrig := OutTrig + Op
      else if( CompareText(Token,'context') = 0 ) then
        OutTrig := OutTrig + context
      else if( CompareText(Token,'tablekey') = 0 ) then
        OutTrig := OutTrig + Fields.Strings[0]
      else if( CompareText(Token,'op') = 0 ) then
        OutTrig := OutTrig + Op[1]
      else if( CompareText(Token,'username') = 0 ) then
        OutTrig := OutTrig + ReplUserName;
    end;

    OutTrig := OutTrig + TempLine;

    if( Pos('CREATE', AnsiUpperCase(OutTrig)) > 0 ) then begin
      TrigName := GetTrigName( OutTrig );
      if( CheckTrigExists( TrigName ) ) then begin
        OutTrig := ChangeTrigToAlter( OutTrig );
      end;
    end;

    TriggerMemo.Lines.Add(OutTrig);
  end;
end;

procedure TReplManagerShell.DropTrigger( Table : string; Op : string; TrigTemp: TStringList );
var
  OutTrig : string[80];
  TempLine: string[80];
  i, StartPos, EndPos: Integer;
  Token: string[32];
  TrigName: string[32];
begin
  for i := 0 to TrigTemp.Count-1 do begin
    TempLine := TrigTemp[i];
    StartPos := Pos('@@',TempLine);
    OutTrig := '';
    while( StartPos > 0 ) do begin
      OutTrig := OutTrig + Copy(TempLine, 1, StartPos - 1);
      Delete(TempLine,1,StartPos+1);
      EndPos := Pos('@@',TempLine);
      Token := Copy( TempLine, 1, EndPos-1);
      Delete(TempLine,1,EndPos+1);
      StartPos := Pos('@@',TempLine);

      if( CompareText(Token,'table') = 0 ) then
        OutTrig := OutTrig + Table
      else if( CompareText(Token,'action') = 0 ) then
        OutTrig := OutTrig + Op
      else if( CompareText(Token,'op') = 0 ) then
        OutTrig := OutTrig + Op[1]
      else if( CompareText(Token,'username') = 0 ) then
        OutTrig := OutTrig + ReplUserName;
    end;

    OutTrig := OutTrig + TempLine;

    if(Pos('CREATE',AnsiUpperCase(OutTrig)) > 0 ) then
    begin
      TriggerMemo.Lines.Add('DROP TRIGGER '+ GetTrigName(OutTrig));
      break;
    end;
  end;
end;

procedure TReplManagerShell.TrigSaveBtnClick(Sender: TObject);
begin
  SaveDialog1.Execute;
  if(SaveDialog1.FileName <> '' ) then
    TriggerMemo.Lines.SaveToFile(SaveDialog1.FileName);
end;

procedure TReplManagerShell.FormCreate(Sender: TObject);
begin
  FNewMenuActions := TList.Create;
  UpdateActionMainMenuBar(MainMenu1);
  TableList := TStringList.Create;
  FieldList := TStringList.Create;
  DeleteTriggersList := TStringList.Create;
  DBList := TStringList.Create;
  Read_Registry;
//  WorkingPath := GetWorkingPath;

{  if( Length(WorkingPath) > 0 ) then begin
  end;}
  acnOpenDBExecute(self);
end;

function TReplManagerShell.GetWorkingPath: string;
var
  IniFile: TIniFile;
  WPaths: TStringList;
  Path: string[255];
begin
  WPaths := TStringList.Create;
  IniFile := TIniFile.Create('FBREPL.INI');
  srReplServer:= IniFile.ReadString('ReplMgmt', 'Server', 'Not Found');
  srReplPath:= IniFile.ReadString('ReplMgmt', 'Path', 'Not Found');
  srReplUser:= IniFile.ReadString('ReplMgmt', 'UserName', 'Not Found');
  srReplPWord:= IniFile.ReadString('ReplMgmt', 'Password', 'Not Found');
  Path := srReplPath;
  if (StrComp('Not Found',PChar(srReplPath)) = 0) or(StrComp('Not Found',PChar(srReplServer))=0) then begin
    ShowMessage('Cannot find FBREPL.INI or the ReplMgmt section is missing.  See readme.txt included with Replication Server zip file.');
    Path := '';
  end else begin
    Path := Trim(Path);
    if( Path[Length(Path)] = '\' ) then
      Delete(Path, Length(Path), 1 );
  end;

  GetWorkingPath := Path;
end;

procedure TReplManagerShell.FormDestroy(Sender: TObject);
begin
  FNewMenuActions.Free;
  TableList.Free;
  FieldList.Free;
  DBList.Free;
  SourceDB.Close;
  ReplDB.Close;
  ReplManagerShell := nil;
end;

function TReplManagerShell.VerifyIntegerCol(ColName: String; TableName: String): boolean;
var
  IsInteger: boolean;
begin
  IsInteger := False;

  with QuerySource do
  begin
    SQL.Clear;
    { Get the fields that are not computed }
    SQL.Add('Select F.RDB$FIELD_TYPE FROM');
    SQL.Add('RDB$RELATION_FIELDS RF, RDB$FIELDS F');
    SQL.Add('WHERE RF.RDB$FIELD_SOURCE = F.RDB$FIELD_NAME AND');
    SQL.Add('RF.RDB$RELATION_NAME = :TABLENAME');
    SQL.Add('AND RF.RDB$FIELD_NAME = :COLNAME');
    ParamByName('TABLENAME').AsString := TableName;
    ParamByName('COLNAME').AsString := ColName;
    SourceDB.StartTransaction;
    Open;
    if not EOF then begin
      if( (Fields[0].AsInteger = IB_SMALLINT) or
          (Fields[0].AsInteger = IB_INTEGER) or
          (Fields[0].AsInteger = IB_BIGINTEGER)) then
        IsInteger := True;
    end;
    Close;
  end;
  SourceDB.Commit;

  VerifyIntegerCol := IsInteger;
end;

procedure TReplManagerShell.Button1Click(Sender: TObject);
var
  NewPath: string[255];
begin
  Form2.LocPath := 'server[/port]:[drive]\path\filename.ext';
  Form2.User := '';
  Form2.Password := '';
  Form2.RasServiceName := '';
  Form2.RasUser := '';
  Form2.RasPassword := '';

  if(Form2.ShowModal = mrOK) then
  begin
    with QueryRepl do
    begin
      SQL.Clear;
      { Get the fields including in any existing REPLDEFS entry}
      SQL.Add('INSERT INTO LOCATIONS (LOC_PATH, RAS_SERVICENAME, ');
      SQL.Add('RAS_USER,RAS_PASSWORD, USERNAME, PASSWD)');
      SQL.Add('VALUES(:LP, :RS, :RU, :RP, :U, :P)');
      ParamByName('LP').AsString := Form2.LocPath;
      ParamByName('RS').AsString := Form2.RasServiceName;
      ParamByName('RU').AsString := Form2.RasUser;
      ParamByName('RP').AsString := Form2.RasPassword;
      ParamByName('U').AsString := Form2.User;
      ParamByName('P').AsString := Form2.Password;

      ReplDB.Commit;
      ReplDB.StartTransaction;
      ExecSQL;
      ReplDB.Commit;

      InitDbList(ReplTable);
    end;
  end;
end;

procedure TReplManagerShell.DbModBtnClick(Sender: TObject);
begin
  if (DualListDlg=nil) then
    DualListDlg := TDualListDlg.Create(self);
  DualListDlg.Caption := 'Modify Target Databases';
  ReadFormPosition(DualListDlg);
  DualListDlg.SrcList.Items := DbSrcList.Items;
  DualListDlg.SrcLabel.Caption := 'Databases';
  DualListDlg.DstList.Items := DbDstList.Items;
  DualListDlg.DstLabel.Caption := 'Target Databases';
  if(DualListDlg.ShowModal = mrOK) then begin
    DbSrcList.Items := DualListDlg.SrcList.Items;
    DbDstList.Items := DualListDlg.DstList.Items;
    DbSaveBtnClick(self);
  end;
end;

procedure TReplManagerShell.DbCancelBtnClick(Sender: TObject);
begin
  DbSrcList.Clear;
  DbDstList.Clear;
  DbSrcList.Items := DbList;
end;

procedure TReplManagerShell.DbSaveBtnClick(Sender: TObject);
var
  i, len: Integer;
  loc_str: string[10];
begin
  if (MessageDlg('Apply target IDs to source database for table '+TableListBox1.Items.Strings[TableListBox1.ItemIndex]+'?', mtConfirmation, [mbOK,mbCancel], 0)=mrOK) then begin
    with QuerySource do begin
      SQL.Clear;
      SQL.Add('DELETE FROM REPL_TABLES ');
      SQL.Add('WHERE TABLENAME = :TABLENAME');

      ParamByName('TABLENAME').AsString := TableListBox1.Items.Strings[TableListBox1.ItemIndex];

      SourceDB.Commit;
      SourceDB.StartTransaction;
      ExecSQL;

      for i:= 0 to DbDstList.Items.Count - 1 do begin
        SQL.Clear;
        SQL.Add('INSERT INTO REPL_TABLES(');
        SQL.Add('TABLENAME, LOC_ID) VALUES (');
        SQL.Add(':TABLENAME,:LOC_ID)');

        ParamByName('TABLENAME').AsString := TableListBox1.Items.Strings[TableListBox1.ItemIndex];

        { parse the location id out of the path string }
        Len := Pos(',',DbDstList.Items.Strings[i]) -1;
        loc_str := Copy(DbDstList.Items.Strings[i], 0, Len);
        ParamByName('LOC_ID').AsString := loc_str;

        ExecSQL;
      end;
    end;

    SourceDB.Commit;
  end;
  BitBtn5Click(self);
end;

procedure TReplManagerShell.CheckBox1Click(Sender: TObject);
begin
  if(CheckBox1.Checked = True) then
    AddEventTrigger
  else
    DropEventTrigger;
end;

procedure TReplManagerShell.AddEventTrigger;
begin
  With EventMemo do
  begin
    Clear;

    Lines.Add('connect "' + Edit1.Text + '";');
    Lines.Add('');

    Lines.Add('set term ^^;');
    Lines.Add('');

    Lines.Add('create trigger CHANGES_INSERT_REPL for CHANGES');
    Lines.Add('after insert as');
    Lines.Add('begin');
    Lines.Add('  POST_EVENT "new_change";');
    Lines.Add('end');
    Lines.Add('^^');

    Lines.Add('');
    Lines.Add('set term ;^^');
  end;
end;

procedure TReplManagerShell.DropEventTrigger;
begin
  With EventMemo do
  begin
    Clear;

    Lines.Add('connect "' + Edit1.Text + '";');
    Lines.Add('');

    Lines.Add('set term ^^;');
    Lines.Add('');

    Lines.Add('drop trigger CHANGES_INSERT_REPL');
    Lines.Add('^^');

    Lines.Add('');
    Lines.Add('set term ;^^');
  end;
end;

procedure TReplManagerShell.EvntSaveBtnClick(Sender: TObject);
begin
  SaveDialog1.Execute;
  if(SaveDialog1.FileName <> '' ) then
    EventMemo.Lines.SaveToFile(SaveDialog1.FileName);
end;

procedure TReplManagerShell.Button2Click(Sender: TObject);
var
  x, LocId, CommaPos: Integer;
  EditDB: string[100];
begin
  EditDB := '';

  x := getFirstSelected( DBDstList );
  if( x > -1 ) then
    EditDB := DBDstList.Items[x]
  else begin
    x := getFirstSelected( DBSrcList );
    if( x > -1 ) then
      EditDB := DBSrcList.Items[x];
  end;

  if( length(EditDB) <> 0 ) then
  begin
    CommaPos := Pos(',', EditDB);
    LocId := StrToInt(Copy(EditDB, 1, CommaPos - 1));

    with QueryRepl do
    begin
      SQL.Clear;
      { Get the fields including in any existing REPLDEFS entry}
      SQL.Add('SELECT LOC_PATH,USERNAME,PASSWD,RAS_SERVICENAME,RAS_USER,RAS_PASSWORD ');
      SQL.Add('FROM LOCATIONS WHERE');
      SQL.Add('LOC_ID = :LOC_ID');
      ParamByName('LOC_ID').AsInteger := LocId;
      ReplDB.Commit;
      ReplDB.StartTransaction;
      Open;

      if (not EOF) then
      begin
        Form2.LocPath := Fields[0].AsString;
        Form2.User := Fields[1].AsString;
        Form2.Password := Fields[2].AsString;
        Form2.RasServiceName := Fields[3].AsString;
        Form2.RasUser := Fields[4].AsString;
        Form2.RasPassword := Fields[5].AsString;
      end;
      Close;
      ReplDB.Commit;

      if(Form2.ShowModal = mrOK) then
      begin
        SQL.Clear;
        { Get the fields including in any existing REPLDEFS entry}
        SQL.Add('UPDATE LOCATIONS SET LOC_PATH = :L,RAS_SERVICENAME =:RS,');
        SQL.Add('RAS_USER = :RU,RAS_PASSWORD = :RP, USERNAME = :U, PASSWD = :P');
        SQL.Add('WHERE LOC_ID = :LOC_ID');
        ParamByName('L').AsString := Form2.LocPath;
        ParamByName('RD').AsString := Form2.RasServiceName;
        ParamByName('RU').AsString := Form2.RasUser;
        ParamByName('RP').AsString := Form2.RasPassword;
        ParamByName('U').AsString := Form2.User;
        ParamByName('P').AsString := Form2.Password;
        ParamByName('LOC_ID').AsInteger := LocId;
        ReplDB.Commit;
        ReplDB.StartTransaction;
        ExecSQL;
        ReplDB.Commit;

        InitDbList(ReplTable);
      end;
    end;
  end;
end;

procedure TReplManagerShell.Button3Click(Sender: TObject);
var
  x, Len: Integer;
  loc_str: string[10];
  DelDB: string[100];
begin
  DelDB := '';

  { get the selected db path }
  x := getFirstSelected( DBDstList );
  if( x > -1 ) then
    DelDB := DBDstList.Items[x]
  else begin
    x := getFirstSelected( DBSrcList );
    if( x > -1 ) then
      DelDB := DBSrcList.Items[x];
  end;

  { if one's selected, confirm choice }
  if( length(DelDB) > 0) then
  begin
    if( MessageDlg('Remove target database from definitions?'+#13+#10+DelDB+#13+#10+'This will remove any pending replication changes for this target.', mtConfirmation, [mbCancel, mbOK], 0) = mrOK ) then
    begin
      { parse out the location id }
      Len := Pos(',',DelDB) -1;
      loc_str := Copy(DelDB, 0, Len);

      { delete any pending changes }
      with QuerySource do
      begin
        SQL.Clear;
        SQL.Add('DELETE FROM CHANGES WHERE LOC_ID = :L');
        ParamByName('L').AsString := loc_str;

        SourceDB.Commit;
        SourceDB.StartTransaction;
        ExecSQL;
        SourceDB.Commit;
      end;

      { delete from global locations table }
      with QueryRepl do
      begin
        SQL.Clear;
        SQL.Add('DELETE FROM LOCATIONS WHERE LOC_ID = :L');
        ParamByName('L').AsString := loc_str;

        ReplDB.Commit;
        ReplDB.StartTransaction;
        ExecSQL;
        ReplDB.Commit;
      end;

      InitDbList(ReplTable);
    end;
  end;
end;

function TReplManagerShell.getFirstSelected( List: TCustomListBox ): Integer;
var
  x: Integer;
begin
  getFirstSelected := -1;
  for x:= 0 to List.Items.Count -1 do
    if List.Selected[x] then
    begin
      getFirstSelected := x;
      Break;
    end;
end;

procedure TReplManagerShell.Button4Click(Sender: TObject);
begin
  if (MessageDlg('Apply triggers to source database?', mtConfirmation, [mbOK,mbCancel], 0)=mrOK )then begin
    ApplyTrigtoDB( TriggerMemo.Lines );
    TriggerMemo.Lines.Clear;
    BitBtn4Click(self);
  end;
end;

procedure TReplManagerShell.ApplyTrigToDB( TrigLines: TStrings );
var
  inTrigger: boolean;
  i: Integer;
  UpLine: string[255];
begin
  try
    SourceDB.Commit;
    SourceDB.StartTransaction;

    QuerySource.SQL.Clear;
    inTrigger := False;

    for i := 0 to TrigLines.Count - 1 do begin
      if( not inTrigger ) then begin
        UpLine := AnsiUpperCase(TrigLines[i]);
        if( (Pos('CREATE', UpLine) > 0) or
            (Pos('ALTER', UpLine) > 0) or
            (Pos('DROP', UpLine) > 0) ) then
          inTrigger := True;
      end else if( Pos('^^', TrigLines[i] ) > 0) then begin
        inTrigger := False;
        QuerySource.ExecSQL;
        QuerySource.SQL.Clear;
      end;

      if( inTrigger = True ) then
        QuerySource.SQL.Add(TrigLines[i]);
    end;
    SourceDB.Commit;
  except
    on E1: EIB_ISCError do begin
      MessageDlg('Cannot Apply Triggers to DB:'+#13+#10+E1.ErrorMessage.Text+#13+#10+'Rolling back changes.', mtError, [mbOK], 0);
      if( SourceDB.inTransaction ) then
        SourceDB.Rollback;
    end;
  end;
end;

function TReplManagerShell.ChangeTrigToAlter( TrigLine: string): string;
var
  UpLine: string[255];
  StartPos: integer;
begin
  UpLine := AnsiUpperCase(TrigLine);
  StartPos := Pos('CREATE', UpLine );
  if( StartPos > 0 ) then
  begin
    Delete( UpLine, StartPos, length('CREATE') );
    StartPos := Pos('FOR', UpLine );
    Delete( UpLine, StartPos, Length(UpLine) - StartPos + 1);
    TrigLine := 'ALTER' + UpLine;
  end;

  ChangeTrigToAlter := TrigLine;
end;

function TReplManagerShell.CheckTrigExists( TrigName: string ): boolean;
begin
  with QuerySource do
  begin
    SQL.Clear;
    SQL.Add('SELECT RDB$TRIGGER_NAME FROM RDB$TRIGGERS WHERE');
    SQL.Add('RDB$TRIGGER_NAME = :TRIG');
    ParamByName('TRIG').AsString := TrigName;

    SourceDB.Commit;
    SourceDB.StartTransaction;
    Open;
    if( not EOF ) then
      CheckTrigExists := True
    else
      CheckTrigExists := False;

    Close;
    SourceDB.Commit;
  end;
end;

function TReplManagerShell.GetTrigName( TrigLine: string ): string;
var
  i, NameStart, NameEnd: Integer;
  TrigName: string[32];
  UpLine: string[255];
  Done: boolean;
begin
  Done := False;
  TrigName := '';

  UpLine := AnsiUpperCase(TrigLine);
  if( Pos('CREATE', UpLine ) > 0 ) then begin
    NameStart := Pos('TRIGGER', UpLine ) + length('TRIGGER') + 1;
    NameEnd := Pos('FOR', UpLine);
    TrigName := Copy(UpLine, NameStart, NameEnd - NameStart);
    TrigName := Trim(TrigName);
  end else begin
    if( (Pos('DROP', UpLine ) > 0) or (Pos('ALTER', UpLine) > 0) ) then begin
      NameStart := Pos('TRIGGER', UpLine) + length('TRIGGER') + 1;
      NameEnd := length(UpLine)+1;
      TrigName := Copy(UpLine, NameStart, NameEnd - NameStart);
      TrigName := Trim(TrigName);
    end;
  end;

  GetTrigName := TrigName;
end;

procedure TReplManagerShell.Button5Click(Sender: TObject);
begin
  if( OKTrigDlg.ShowModal = mrOK ) then
  begin
    ApplyTrigtoDB( EventMemo.Lines );
  end;
end;

procedure TReplManagerShell.acnExitExecute(Sender: TObject);
begin
  Close;
end;

procedure TReplManagerShell.acnAboutExecute(Sender: TObject);
begin
  AboutBox := TAboutBox.Create(Application);
  AboutBox.ShowModal;
  AboutBox.Free;
end;

procedure TReplManagerShell.acnPreferencesExecute(Sender: TObject);
var
  mrRet: Integer;
begin
  Preferences := TPreferences.Create(Application);
//  showmessage(IntToStr(Preferences.ShowModal));
  mrRet := Preferences.ShowModal;
  if (mrRet=mrCancel) then
  else begin
    IBOQuerySources.Close;
    acnOpenDBExecute(self);
    IBOQuerySources.Open;
  end;
  Preferences.Free;
end;

procedure TReplManagerShell.acnOpenDBExecute(Sender: TObject);
begin
  if ((srReplServer<>'') and (srReplServer<>'Not Found'))then begin
    with ReplDB do begin
      Close;
      Server :=  srReplServer;
      Path := srReplPath;
      Username := srReplUser;
      Password:= srReplPWord;
      try
        Open;
        IBOQuerySources.Open;
      except
        on E1: EIB_ISCError do begin
          ShowMessage('Cannot open DB: ' + WorkingPath);
          DispErrorMsg(E1);
        end;
      end;
    end;
  end;
end;

procedure TReplManagerShell.acnCloseDBExecute(Sender: TObject);
begin
  ReplDB.Close;
end;

procedure TReplManagerShell.acnDeleteSourceExecute(Sender: TObject);
var
  progress: String;
  tserver, tpath, tuname, tpword: string;
  i, d, dcount, lcount, trigSetCount: integer;
begin
  tserver := IBOQuerySourcesSOURCE_SERVER.AsString;
  tpath := IBOQuerySourcesSOURCE_PATH.AsString;
  tuname := IBOQuerySourcesUSERNAME.AsString;
  tpword := IBOQuerySourcesPASSWD.AsString;
  trigSetCount := 0;
  if (MessageDlg('Remove all trigger definitions from the source?'+#13+#10+tserver+':'+tpath, mtConfirmation, [mbOK,mbCancel], 0)=mrOK) then begin
    for i:=0 to TableList.Count-1 do begin
      BuildMemoryTriggers( TableListBox1.Items.Strings[ i ], IBOQuerySourcesSOURCE_SERVER.AsString+':'+IBOQuerySourcesSOURCE_PATH.AsString );
      dcount := 0;
      lcount := DeleteTriggersList.Count-1;
      for d:=0 to lcount do begin
        if(Pos('DROP',AnsiUpperCase(DeleteTriggersList[d])) > 0 ) then
          if not (CheckTrigExists( GetTrigName(DeleteTriggersList[d]) )) then begin
            inc(dcount);
          end;
      end;
      case dcount of
        0: begin
          // All triggers exist so run the script
          ApplyTrigtoDB(DeleteTriggersList);
          inc(trigSetCount);
        end;
        1, 2: begin
          // exception where unexpected number of triggers exist
          MessageDlg('There is an anomoly with the number of triggers present for table'+#13+#10+TableListBox1.Items.Strings[ i ]+#13+#10+'Triggers for this table must be dropped manually.', mtWarning, [mbOK], 0);
        end;
        3: begin
          // no triggers exist
        end;
      end;
    end;
    if trigSetCount>0 then
      MessageDlg('Trigger sets for ''+IntToStr(trigSetCount)+'' tables have been '+#13+#10+'removed tot he source database.', mtInformation, [mbOK], 0)
    else
      MessageDlg('No triggers were recognised for removal.', mtInformation, [mbOK], 0);
  end;
  if (MessageDlg('Remove replication table definitions from the source database?'+#13+#10+tserver+':'+tpath, mtConfirmation, [mbOK,mbCancel], 0)=mrOK) then begin
    with SourceDB do begin
      Commit;
      Close;
      Server := tserver;
      Path := tpath;
      Username := tuname;
      Password := tpword;
      Connect;
    end;
    with QuerySource do begin
      try
        Close;
        SQL.Clear;
        SQL.Add('REVOKE SELECT, INSERT ON CHANGES FROM PUBLIC');
        SourceDB.StartTransaction;
        ExecSQL;
        SourceDB.Commit;
        progress := 'CHANGES table permissions removed';

        SQL.Clear;
        SQL.Add('DROP INDEX CHANGES_LOC_ID');
        SourceDB.StartTransaction;
        ExecSQL;
        SourceDB.Commit;
        progress := progress+#13+#10+'CHANGES(LOC_ID) table index dropped';

        SQL.Clear;
        SQL.Add('DROP INDEX CHANGES_TABLENAME');
        SourceDB.StartTransaction;
        ExecSQL;
        SourceDB.Commit;
        progress := progress+#13+#10+'CHANGES(TABLENAME) table index dropped';

        SQL.Clear;
        SQL.Add('DROP TRIGGER INSERT_CHANGES');
        ExecSQL;
        SourceDB.Commit;
        progress := progress+#13+#10+'CHANGES PK trigger dropped';

        SQL.Clear;
        SQL.Add('DROP TABLE CHANGES');
        SourceDB.StartTransaction;
        ExecSQL;
        SourceDB.Commit;
        progress := progress+#13+#10+'CHANGES table dropped';

        SQL.Clear;
        SQL.Add('REVOKE SELECT ON REPL_TABLES FROM PUBLIC');
        ExecSQL;
        SourceDB.Commit;
        progress := progress+#13+#10+'REPL_TABLES permissions removed';

        SQL.Clear;
        SQL.Add('DROP TABLE REPL_TABLES');
        ExecSQL;
        SourceDB.Commit;
        progress := progress+#13+#10+'REPL_TABLES table dropped';

        SQL.Clear;
        SQL.Add('DROP GENERATOR GEN_CHANGECODE');
        ExecSQL;
        SourceDB.Commit;
        progress := progress+#13+#10+'GEN_CHANGECODE generator dropped';

        MessageDlg('Modifications carried out:'+#13+#10+progress, mtInformation, [mbOK], 0);
      except
        on E1: EIB_ISCError do begin
          MessageDlg('Cannot remove replication definitions!'+#13+#10+'Rolling back last attempted change.'+#13+#10+E1.ErrorMessage.Text, mtError, [mbOK], 0);
          if( SourceDB.inTransaction ) then
            SourceDB.Rollback;
        end;
      end;
    end;
  end;
  if (MessageDlg('Remove source database'+#13+#10+tserver+':'+tpath+#13+#10+'from the current replicate.fdb file?', mtConfirmation, [mbOK,mbCancel], 0)=mrOK) then begin
    ReplDB.Commit;
    with QueryRepl do begin
      Close;
      SQL.Clear;
      SQL.Add('DELETE FROM SOURCE_LOCATION WHERE ID='+IBOQuerySourcesID.AsString);
      ReplDB.StartTransaction;
      ExecSQL;
      ReplDB.Commit;
    end;
    IBOQuerySources.Refresh;
  end;
  acnRefreshSourceTablesExecute(self);
end;

procedure TReplManagerShell.acnRefreshSourceTablesExecute(Sender: TObject);
var
  AliasParams: TStringList;
begin
      { open the db }
      with SourceDB do begin
        Close;
        Server := IBOQuerySourcesSOURCE_SERVER.AsString;
        Path := IBOQuerySourcesSOURCE_PATH.AsString;
        Username := IBOQuerySourcesUSERNAME.AsString;
        Password := IBOQuerySourcesPASSWD.AsString;
        ReplUsername := IBOQuerySourcesREPLUSER.AsString;
        try
          Open;
        except
          on E1: EIB_ISCError do begin
            ShowMessage('Cannot open DB: ' + IBOQuerySourcesSOURCE_PATH.AsString);
            DispErrorMsg(E1);
          end;
        end;
      end;
      { Verify the selected db has the necessary replication tables }
      if( CountReplTables > 0 ) then begin
       // SaveSourceDB(SourceDB.Server, SourceDB.Path, OpenDBDlg.UserName, OpenDBDlg.Password );
        UserName := IBOQuerySourcesUSERNAME.AsString;
        InitTableList;
        TableListBox1.ItemIndex := 0;
        TableListBox1DblClick(self);
      end else begin
        if (MessageDlg('Source database:'+#13+#10+IBOQuerySourcesSOURCE_SERVER.AsString+':'+IBOQuerySourcesSOURCE_PATH.AsString+#13+#10+'is not setup for replication.'+#13+#10+''+#13+#10+'Do you wish to setup this source database for replication?', mtConfirmation, [mbOK,mbCancel], 0)=mrOK) then begin
//        SetupDB.Label1.Caption := IBOQuerySourcesSOURCE_SERVER.AsString+':'+IBOQuerySourcesSOURCE_PATH.AsString;
//        if( SetupDB.ShowModal = mrOK ) then begin
          SetupReplTables;
          SaveSourceDB(SourceDB.Server, SourceDB.Path, OUserName, OPassword, RUserName, RPassword );
          UserName := OUserName;
          InitTableList;
          TableListBox1.ItemIndex := 0;
        end else
          SourceDB.Close;
      end;
end;

procedure TReplManagerShell.acnEditColumnDefsExecute(Sender: TObject);
begin
  if (DualListDlg=nil) then
    DualListDlg := TDualListDlg.Create(self);
  DualListDlg.Caption := 'Modify Columns';
  ReadFormPosition(DualListDlg);
  DualListDlg.SrcList.Items := ColSrcList.Items;
  DualListDlg.SrcLabel.Caption := 'Available Columns';
  DualListDlg.DstList.Items := ColDstList.Items;
  DualListDlg.DstLabel.Caption := 'Replicated Columns';
  if(DualListDlg.ShowModal = mrOK) then begin
    if(DualListDlg.DstList.Items.Count > 0 ) then begin
      if(VerifyIntegerCol(DualListDlg.DstList.Items.Strings[0], ReplTable)) then begin
        ColSrcList.Items := DualListDlg.SrcList.Items;
        ColDstList.Items := DualListDlg.DstList.Items;
      end else
        ShowMessage(DualListDlg.DstList.Items.Strings[0] + ' is not an Integer!');
    end else begin
      ColSrcList.Items := DualListDlg.SrcList.Items;
      ColDstList.Items := DualListDlg.DstList.Items;
    end;
    ColSaveBtnClick(self);
  end;
end;

procedure TReplManagerShell.acnEditSourceExecute(Sender: TObject);
var
  AliasParams: TStringList;
  msgmessage: String;
begin
  if (OpenDBDlg=nil) then
    OpenDBDlg := TOpenDBDlg.Create(self);
    OpenDBDlg.Caption := 'Edit Source Details';
  ReadFormPosition(OpenDBDlg);
  with OpenDBDlg do begin
    Edit1.Text := IBOQuerySourcesUSERNAME.AsString;
    Edit2.Text := IBOQuerySourcesPASSWD.AsString;
    Edit3.Text := IBOQuerySourcesREPLUSER.AsString;
    Edit4.Text := IBOQuerySourcesREPLPASSWD.AsString;
    Edit5.Text := IBOQuerySourcesSOURCE_SERVER.AsString+':'+IBOQuerySourcesSOURCE_PATH.AsString;
    ComboBox1.Visible := False;
    Edit5.Visible := True;
  end;
  if( OpenDBDlg.ShowModal = mrOK ) then begin
    if( ADBPath <> '') then begin
      { open the db }
      with SourceDB do begin
        Close;
        Server := copy(ADBPath,0,Pos(':',ADBPath)-1);
        Path := copy(ADBPath,Pos(':',ADBPath)+1,255);
        Username := OUsername;
        Password := OPassword;
        try
          Open;
        except
          on E1: EIB_ISCError do begin
            MessageDlg('Cannot open database:'+#13+#10+ADBPath+#13+#10+E1.ErrorMessage.Text, mtError, [mbOK], 0);
          end;
        end;
      end;
      { Verify the selected db has the necessary replication tables }
      if( CountReplTables > 0 ) then begin
        EditSourceDB(SourceDB.Server, SourceDB.Path, OUserName, OPassword, RUserName, RPassword, IBOQuerySourcesID.AsInteger );
        UserName := OUserName;
        InitTableList;
        TableListBox1.ItemIndex := 0;
        TableListBox1DblClick(self);
      end else begin
        msgmessage := 'Source database:'+#13+#10+IBOQuerySourcesSOURCE_SERVER.AsString+':'+IBOQuerySourcesSOURCE_PATH.AsString;
        msgMessage := msgmessage +#13+#10+'is not setup for replication.'+#13+#10+''+#13+#10+'Do you wish to setup this source database for replication?';
        msgMessage := msgmessage +#13+#10+#13+#10+'This process will add the CHANGES and REPL_TABLES tables to the source.';
        if (MessageDlg(msgmessage, mtConfirmation, [mbOK,mbCancel], 0)=mrOK) then begin
          SetupReplTables;
          EditSourceDB(SourceDB.Server, SourceDB.Path, OUserName, OPassword, RUserName, RPassword, IBOQuerySourcesID.AsInteger );
          UserName := OUserName;
          InitTableList;
          TableListBox1.ItemIndex := 0;
        end else
          SourceDB.Close;
      end;
    end;
  end;
end;

procedure TReplManagerShell.TableListBox1DblClick(Sender: TObject);
var
  Index, i, dcount: Integer;
begin
  ColDstList.Clear;
  ColSrcList.Clear;
  Index := TableListBox1.ItemIndex;
  ReplTable := TableListBox1.Items.Strings[ Index ];
  InitDstFields( ReplTable );
  InitSrcFields( ReplTable );
  if( ColDstList.Items.Count > 0 ) then
    BuildTriggers( ColDstList.Items, ReplTable, IBOQuerySourcesSOURCE_SERVER.AsString+':'+IBOQuerySourcesSOURCE_PATH.AsString )
  else begin
    // ColDstLost may be empty but the trigger may still exist,
    // therefore needs to be dropped
    BuildTriggers( ColDstList.Items, ReplTable, IBOQuerySourcesSOURCE_SERVER.AsString+':'+IBOQuerySourcesSOURCE_PATH.AsString );
    // Now I have the triggers defined as DROP triggers
    // I need to walk thru the memo and test each trigger name.
    dcount := 0;
    for i := 0 to TriggerMemo.Lines.Count-1 do begin
      if(Pos('DROP',AnsiUpperCase(TriggerMemo.Lines[i])) > 0 ) then
        if not (CheckTrigExists( GetTrigName(TriggerMemo.Lines[i]) )) then begin
          TriggerMemo.Lines.Delete(i);
          inc(dcount);
        end;
    end;
    // Trigger does not exist therefore clear Triggermemo
    if (dcount=3) then
      TriggerMemo.Clear;
  end;
  InitDbList( ReplTable );
end;

{ This method adds placeholders to the TActionMainMenuBar that represent the
  top level menu item.  Each placeholder item has a single "dummy" item that
  is replaced by the actual menu should the user select that top level item.
  This allows the TMainMenu to be changed dynamically at runtime and still have
  the TActionMainMenuBar reflect the latest changes.
}
procedure TReplManagerShell.UpdateActionMainMenuBar(Menu: TMenu);

  { This routine should probably also check for Enabled state although it would
    be very wierd to have a top level menu disabled. }
  function RefreshItems: Boolean;
  var
    I: Integer;
  begin
    Result := Menu.Items.Count <> ActionManager1.ActionBars[0].Items.Count;
    if not Result then
      for I := 0 to Menu.Items.Count - 1 do
        if AnsiCompareText(Menu.Items[I].Caption, ActionManager1.ActionBars[0].Items[I].Caption) <> 0 then
        begin
          Result := True;
          break;
        end;
  end;

begin
  if not (csLoading in ActionManager1.ComponentState) and RefreshItems then
  begin
    // Clear any existing items and repopulate the TActionMainMenuBar
    ActionManager1.ActionBars[0].Items.Clear;
    ActionManager1.ActionBars[0].ActionBar := nil;
    LoadMenu(ActionManager1, ActionManager1.ActionBars[0].Items, Menu.Items);
    ActionManager1.ActionBars[0].ActionBar := ActionMainMenuBar1;
    // Update the size of the main menu
    with ActionMainMenuBar1 do
      SetBounds(0, 0, Controls[ControlCount - 1].BoundsRect.Right + 2 + ActionMainMenuBar1.HorzMargin, Height);
  end;
end;

{ This method dynamically builds the ActionBand menu from an existing
  TMenuItem. }
procedure TReplManagerShell.LoadMenu(ActionList: TCustomActionList;
  Clients: TActionClients; AMenu: TMenuItem; SetActionList: Boolean = True);
var
  I: Integer;
  AC: TActionClientItem;
begin
  AMenu.RethinkHotkeys;
  AMenu.RethinkLines;
  // Use the existing hotkeys from the TMenuItem
  Clients.AutoHotKeys := False;
  for I := 0 to AMenu.Count - 1 do
  begin
    AC := Clients.Add;
    AC.Caption := AMenu.Items[I].Caption;
    // Assign the Tag property to the TMenuItem for reference
    AC.Tag := Integer(AMenu.Items[I]);
    AC.Action := TContainedAction(AMenu.Items[I].Action);
    AC.Visible := AMenu.Items[I].Visible;
    // If the TMenuItem has subitems add an ActionClient placeholder.
    // Submenus are only populated when the user selects the parent item of the
    // submenu.
    if AMenu.Items[I].Count > 0 then
      AC.Items.Add  // Add a dummy indicating this item can/should be dynamically built
    else
      if ((AMenu.Items[I].Caption <> '') and (AMenu.Items[I].Action = nil) and
          (AMenu.Items[I].Caption <> '-')) then
      begin
        // The TMenuItem is not connected to an action so dynamically create
        // an action.
        AC.Action := TABMenuAction.Create(Application.MainForm);
        AMenu.Items[I].FreeNotification(AC.Action);
        TABMenuAction(AC.Action).FMenuItem := AMenu.Items[I];
        FNewMenuActions.Add(AC.Action);
        AC.Action.ActionList := ActionManager1;
        AC.Action.Tag := AMenu.Items[I].Tag;
        TCustomAction(AC.Action).ImageIndex := AMenu.Items[I].ImageIndex;
        TCustomAction(AC.Action).HelpContext := AMenu.Items[I].HelpContext;
        TCustomAction(AC.Action).Visible := AMenu.Items[I].Visible;
        TCustomAction(AC.Action).Checked := AMenu.Items[I].Checked;
        TCustomAction(AC.Action).Caption := AMenu.Items[I].Caption;
        TCustomAction(AC.Action).ShortCut := AMenu.Items[I].ShortCut;
        TCustomAction(AC.Action).Enabled := AMenu.Items[I].Enabled;
        TCustomAction(AC.Action).AutoCheck := AMenu.Items[I].AutoCheck;
        TCustomAction(AC.Action).Checked := AMenu.Items[I].Checked;
        TCustomAction(AC.Action).GroupIndex := AMenu.Items[I].GroupIndex;
        AC.ImageIndex := AMenu.Items[I].ImageIndex;
        AC.ShortCut := AMenu.Items[I].ShortCut;
      end;
    AC.Caption := AMenu.Items[I].Caption;
    AC.ImageIndex := AMenu.Items[I].ImageIndex;
    AC.HelpContext := AMenu.Items[I].HelpContext;
    AC.ShortCut := AMenu.Items[I].ShortCut;
    AC.Visible := AMenu.Items[I].Visible;
  end;
end;

procedure TReplManagerShell.ActionMainMenuBar1ExitMenuLoop(
  Sender: TCustomActionMenuBar; Cancelled: Boolean);
var
  I: Integer;
  AnAction: TObject;
begin
  // Clear the top level menu sub item and add a single dummy item which
  // will cause them to be regenerated on the next menu loop.  This is done
  // because the IDE's menus can be very dynamic and this ensures that the
  // menus will always be up-to-date.
  for I := 0 to ActionManager1.ActionBars[0].Items.Count - 1 do
  begin
    ActionManager1.ActionBars[0].Items[I].Items.Clear;
    ActionManager1.ActionBars[0].Items[I].Items.Add;
  end;
  // Any menuitems not linked to an action had one dynamically created for them
  // during the menu loop so now we need to destroy them
  while FNewMenuActions.Count > 0 do
  begin
    AnAction := TObject(FNewMenuActions.Items[0]);
    AnAction.Free;
    FNewMenuActions.Delete(0);
  end;
end;

procedure TReplManagerShell.ActionMainMenuBar1Popup(Sender: TObject;
  Item: TCustomActionControl);
begin
  // If the tag is not zero then we've already populated this submenu...
  if Item.ActionClient.Items[0].Tag <> 0 then exit;
  // ...otherwise this is the first visit to this submenu and we need to
  // populate the actual ActionClients collection.
  if Assigned(TMenuItem(Item.ActionClient.Tag).OnClick) then
    TMenuItem(Item.ActionClient.Tag).OnClick(TMenuItem(Item.ActionClient.Tag));
  Item.ActionClient.Items.Clear;
  TMenuItem(Item.ActionClient.Tag).RethinkHotkeys;
  LoadMenu(ActionManager1, Item.ActionClient.Items, TMenuItem(Item.ActionClient.Tag), False);
end;

procedure TReplManagerShell.IBOQuerySourcesAfterScroll(DataSet: TDataSet);
begin
  acnRefreshSourceTablesExecute(self);
end;

procedure TReplManagerShell.acnAddSourceExecute(Sender: TObject);
begin
  BtnDBOpenClick(self);
end;

procedure TReplManagerShell.BitBtn3Click(Sender: TObject);
begin
  PageControl1.ActivePage := TabSheet2;
end;

procedure TReplManagerShell.BitBtn4Click(Sender: TObject);
begin
  PageControl1.ActivePage := TabSheet3;
end;

procedure TReplManagerShell.BitBtn5Click(Sender: TObject);
begin
  PageControl1.ActivePage := TabSheet1;
end;

procedure TReplManagerShell.IBOQuerySourcesNewRecord(DataSet: TDataSet);
begin
  Abort;
end;

procedure TReplManagerShell.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  WriteFormPosition(self);
  Action := caFree;
end;

procedure TReplManagerShell.PnlColumnsResize(Sender: TObject);
begin
  PnlAvailableCols.Width := Trunc((PnlColumns.Width)/2)-10;
end;

procedure TReplManagerShell.PnlDBsResize(Sender: TObject);
begin
  PnlAvailDBs.Width := Trunc(PnlDBs.Width/2)-10;
end;

end.
