unit MainForm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Menus, ExtCtrls, StdCtrls, ComCtrls, WinSvc,
  WinTypes, WinProcs, IniFiles, Buttons,
  IdMessage, IdBaseComponent, IdComponent, IdTCPServer, IdSMTPServer, Reg, FBReplConst,
  IdTCPConnection, IdTCPClient, IdMessageClient, IdSMTP, abcedbtn, abcedtsv,
  IB_Components, IdExplicitTLSClientServerBase, IdSMTPBase;

type
  TMainControlForm = class(TForm)
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    Image2: TImage;
    StaticText1: TStaticText;
    StatusText: TStaticText;
    Image1: TImage;
    StaticText2: TStaticText;
    SpeedButton2: TSpeedButton;
    SpeedButton3: TSpeedButton;
    SpeedButton4: TSpeedButton;
    SpeedButton5: TSpeedButton;
    GroupBox2: TGroupBox;
    CBEvent: TCheckBox;
    Label1: TLabel;
    EInterval: TEdit;
    Label2: TLabel;
    SpeedButton6: TSpeedButton;
    TabSheet3: TTabSheet;
    SpeedButton7: TSpeedButton;
    SpeedButton8: TSpeedButton;
    GroupBox3: TGroupBox;
    Label3: TLabel;
    cbUseEmailAlerts: TCheckBox;
    Edit1: TEdit;
    TabSheet4: TTabSheet;
    GroupBox1: TGroupBox;
    Edit2: TEdit;
    StaticText6: TStaticText;
    StaticText7: TStaticText;
    ReplPath: TEdit;
    StaticText8: TStaticText;
    Edit4: TEdit;
    StaticText9: TStaticText;
    Edit5: TEdit;
    SpeedButton9: TSpeedButton;
    SpeedButton10: TSpeedButton;
    Label4: TLabel;
    Edit6: TEdit;
    IdSMTP1: TIdSMTP;
    Label5: TLabel;
    Edit3: TEdit;
    Label6: TLabel;
    Edit7: TEdit;
    CheckBox1: TCheckBox;
    GroupBox4: TGroupBox;
    Label7: TLabel;
    Edit8: TEdit;
    Label8: TLabel;
    Edit9: TEdit;
    IdMessage1: TIdMessage;
    SpeedButton1: TSpeedButton;
    SpeedButton11: TSpeedButton;
    SpeedButton12: TSpeedButton;
    Label9: TLabel;
    abcFileSaveEdit1: TabcFileSaveEdit;
    TabSheet5: TTabSheet;
    GroupBox5: TGroupBox;
    Label10: TLabel;
    CheckBox2: TCheckBox;
    Edit10: TEdit;
    SpeedButton13: TSpeedButton;
    SpeedButton14: TSpeedButton;
    CheckBox3: TCheckBox;
    Label11: TLabel;
    Image3: TImage;
    CheckBox4: TCheckBox;
    Label12: TLabel;
    IB_Connection1: TIB_Connection;
    Label13: TLabel;
    Edit11: TEdit;
    procedure ViewErrors1Click(Sender: TObject);
    procedure ShutDown1Click(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure FormCreate(Sender: TObject);
    procedure SaveEdits5Click(Sender: TObject);
    procedure About6Click(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure SpeedButton3Click(Sender: TObject);
    procedure SpeedButton12Click(Sender: TObject);
    procedure SpeedButton11Click(Sender: TObject);
  private
    { Private declarations }
    procedure HandleError(ErrorMsg:string);
    function ArOpenServices(Service: string): Boolean;
    function ServiceStop(Service: string): Boolean;
    function StopFB: Boolean;
    function ServiceStart(Service: string): Boolean;
    function StartFB: Boolean;
    function IsRunning: boolean;
    function CreateLogFileName: String;
  public
    { Public declarations }
    ErrorFile : array[0..254] of Char;
  end;

var
  MainControlForm: TMainControlForm;
  FB_Auto : Boolean;    // Automatico / Automatic
  FB_IsRun: Boolean;    // Firebird Activo / Firebird is Running
  FB_Serv : Boolean;    //  um Servio / Running as a service
  FB_Guard: Boolean;    // Guardian est a correr / Guardian is Running

  SvcManager  : SC_HANDLE;
  SvcService  : SC_HANDLE;
  SvcStatus   : TServiceStatus;


implementation

uses
  About, ErrorLog;

{$R *.DFM}

function TMainControlForm.CreateLogFileName: String;
var
  CurrentTimeStamp: TDateTime;
  Year, Month, Day: Word;
begin
  CurrentTimeStamp := Now;
  DecodeDate(CurrentTimeStamp, Year, Month, Day);
  Result := IntToStr(Year) +'-'+ IntToStr(Month) +'-'+ IntToStr(Day) +'-';
end;


function TMainControlForm.ArOpenServices( Service : string ) : Boolean;
begin
  Result := True;
  SvcManager:= OpenSCManager( nil, nil, SC_MANAGER_ALL_ACCESS);
  if SvcManager<=0 then
    Result := False
  else begin
    SvcService := OpenService( SvcManager, 'FBReplicator', SERVICE_ALL_ACCESS );
    if SvcService<=0 then begin
      CloseServiceHandle( SvcManager );
      Result := False;
    end;
  end;
end;

function TMainControlForm.ServiceStop( Service : string ) : Boolean;
begin
  Result := False;
  if ArOpenServices( Service ) then begin
    if ControlService( SvcService,SERVICE_CONTROL_STOP,SvcStatus) then begin
      Sleep(1000);
      while (QueryServiceStatus(SvcService,SvcStatus)) do begin
        Application.ProcessMessages;
        if SvcStatus.dwCurrentState=SERVICE_STOP_PENDING then
            Sleep(1000)
          else
            break;
      end;
      if SvcStatus.dwCurrentState=SERVICE_STOPPED then
        Result := True;
    end;
  end;
end;

function TMainControlForm.StopFB : Boolean;
var
  WHand   : HWND;
begin
  Screen.Cursor := crHourglass;
  Result := False;
  Result := ServiceStop( 'FBRepl' );
  Screen.Cursor := crDefault;
end;

function TMainControlForm.ServiceStart( Service : string ) : Boolean;
var
  Argv    : PChar;
begin
  Result := False;
  if ArOpenServices( Service ) then begin
    if StartService(SvcService,0,Argv) then begin
      Sleep(1000);
      while (QueryServiceStatus(SvcService,SvcStatus)) do begin
        Application.ProcessMessages;
        if SvcStatus.dwCurrentState=SERVICE_START_PENDING then
          Sleep(1000)
        else
          break;
      end;
    if SvcStatus.dwCurrentState=SERVICE_RUNNING then
      Result := True;
    end;
  end;
end;

function TMainControlForm.StartFB  : Boolean;
var
  ExeName : array[0..255] of char;
begin
  Screen.Cursor := crHourglass;
  Result := False;
  Result := ServiceStart( 'FBRepl' );
  Screen.Cursor := crDefault;
end;

function TMainControlForm.IsRunning(): boolean;
begin
  Result := False;
  if ArOpenServices( 'FBRepl' ) then begin
    if QueryServiceStatus( SvcService, SvcStatus ) then
      Result := SvcStatus.dwCurrentState=SERVICE_RUNNING;
    CloseServiceHandle( SvcService );
    CloseServiceHandle( SvcManager );
  end;
end;

procedure TMainControlForm.HandleError(ErrorMsg:string);
var
  F:Textfile;
  FileId : Integer;
begin
  if (not FileExists(ErrorFile)) then begin
    FileId := FileCreate(ErrorFile);
    if FileId > 0 then begin
      FileClose(FileId);
    end;
  end;
  AssignFile(F,ErrorFile);
  Append(F);
  Writeln(F,DateTimeToStr(Now) + ' '+ErrorMsg);
  CloseFile(F);
//  Inc(AnyErrors);
//  Inc(TotalErrors);
//  LatestError := ErrorMsg;
end;


procedure TMainControlForm.FormCreate(Sender: TObject);
var
  slFileName: String;
begin
  Read_Registry;
  PageControl1.ActivePage := TabSheet1;
  Height := 286;
  Width := 370;
  // Database Tab
  Edit2.Text := srReplServer;
  ReplPath.Text := srReplPath;
  Edit4.Text := srReplUser;
  Edit5.Text := srReplPWord;
  // Email Settings Tab
  Edit1.Text := srEmail;
  Edit3.Text := srSMTPLogin;
  Edit6.Text := srSMTPHost;
  Edit7.Text := srSMTPPWord;
  Edit8.Text := IntToStr(irTolerance);
  Edit9.Text := IntToStr(irHeartBeat);
  Edit10.Text := IntToStr(irMaxBlobSize);
  CheckBox2.checked := brVerbose;
  cbUseEmailAlerts.checked := brUseEmailAlerts;
  CheckBox1.checked := brUseSMTPAuthentication;
  CheckBox3.checked := breHeartbeat;
  CheckBox4.checked := brShowStats;
  Edit11.Text := srFromAddress;
  // Options Tab
  CBEvent.Checked := brEvtStr;
  EInterval.Text := srInterval;
  slFileName := CreateLogFileName();
  slFileName := ExcludeTrailingPathDelimiter(ExtractFilePath(srReplLogFile))+'\'+slFileName+ExtractFileName(srReplLogFile);
  StrCopy(ErrorFile,PChar(slFileName));
  abcFileSaveEdit1.Text := srReplLogFile;
  abcFileSaveEdit1.SaveDialog.FileName := srReplLogFile;
  ReadFormPosition(self);
  FB_IsRun:= IsRunning;
  if FB_IsRun then begin
    SpeedButton4.Caption := 'Stop Service';
    SpeedButton4.Font.Color := clRed;
    StatusText.Font.Color := clGreen;
    StatusText.Caption := 'Running';
    Image3.Visible := False;
    Image2.Visible := True;
  end else begin
    SpeedButton4.Caption := 'Start Service';
    SpeedButton4.Font.Color := clGreen;
    StatusText.Font.Color := clRed;
    StatusText.Caption := 'Stopped';
    Image3.Visible := True;
    Image2.Visible := False;
  end;
end;

procedure TMainControlForm.ViewErrors1Click(Sender: TObject);
begin
   errordialog := Terrordialog.Create(self);
end;

procedure TMainControlForm.ShutDown1Click(Sender: TObject);
begin
  SaveEdits5Click(self);
  if ((Sender as TSpeedButton).Caption='Stop Service') and FB_IsRun then begin
    FB_IsRun := not StopFB;
    SpeedButton4.Caption := 'Start Service';
    SpeedButton4.Font.Color := clGreen;
    StatusText.Font.Color := clRed;
    StatusText.Caption := 'Stopped';
    Image3.Visible := True;
    Image2.Visible := False;
  end else begin
    FB_IsRun := StartFB;
    SpeedButton4.Caption := 'Stop Service';
    SpeedButton4.Font.Color := clRed;
    StatusText.Font.Color := clGreen;
    StatusText.Caption := 'Running';
    Image3.Visible := False;
    Image2.Visible := True;
  end
end;

procedure TMainControlForm.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
  CanClose := True;
end;

procedure TMainControlForm.SaveEdits5Click(Sender: TObject);
begin
  // Database Tab
  srReplServer := Edit2.Text;
  srReplPath := ReplPath.Text;
  srReplUser := Edit4.Text;
  srReplPWord := Edit5.Text;
  // Email Settings Tab
  srEmail := Edit1.Text;
  srSMTPHost := Edit6.Text;
  srSMTPLogin := Edit3.Text;
  srSMTPPWord := Edit7.Text;
  irTolerance := StrToInt(Edit8.Text);
  irHeartBeat := StrToInt(Edit9.Text);
  brUseEmailAlerts := cbUseEmailAlerts.checked;
  brUseSMTPAuthentication := CheckBox1.checked;
  // Options Tab
  brEvtStr := CBEvent.Checked;
  srInterval := EInterval.Text;
  srReplLogFile := abcFileSaveEdit1.Text;
  irMaxBlobSize := StrToInt(Edit10.Text);
  brVerbose := CheckBox2.checked;
  breHeartbeat := CheckBox3.checked;
  brShowStats := CheckBox4.checked;
  srFromAddress := Edit11.Text;

//  IBEvent.Interval := StrToInt(srInterval)*1000*60;
  Write_Registry;
end;

procedure TMainControlForm.About6Click(Sender: TObject);
begin
  AboutBox := TAboutBox.Create(Application);
  AboutBox.ShowModal;
  AboutBox.Free;
end;

procedure TMainControlForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  SaveEdits5Click(self);
  WriteFormPosition(self);
end;

procedure TMainControlForm.SpeedButton3Click(Sender: TObject);
begin
  SaveEdits5Click(self);
  Close;
end;

procedure TMainControlForm.SpeedButton12Click(Sender: TObject);
begin
  SaveEdits5Click(self);
  //**************
  // Send test email
  //**************
  IdSMTP1.Host := srSMTPHost;
  if brUseSMTPAuthentication then begin
    IdSMTP1.Username := srSMTPLogin;
    IdSMTP1.Password := srSMTPPWord;
    IdSMTP1.AuthType := atDefault;
  end else begin
    IdSMTP1.Username := '';
    IdSMTP1.Password := '';
    IdSMTP1.AuthType := atNone;
  end;
  try
    IdSMTP1.Connect;
  except
    on E:Exception do begin
      HandleError('Error connecting to SMTP server: '+E.Message);
    end;
  end;
  // Send test email
  idMessage1.From.Name := srReplServer;
  idMessage1.From.Address := srReplServer+'@'+srFromAddress;
  idMessage1.Sender.Address := srReplServer+'@'+srFromAddress;
  idMessage1.Sender.Name := srReplServer;
  idMessage1.Recipients[0].Name := '';
  idMessage1.Recipients[0].Address := srEmail;
  idMessage1.ReplyTo[0].Name := srReplServer;
  idMessage1.ReplyTo[0].Address := srReplServer+'@'+srFromAddress;
  idMessage1.Subject := 'FBReplicator Test Message';
  idMessage1.Body.Clear;
  idMessage1.Body.Add('<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 3.2//EN">');
  idMessage1.Body.Add('<html>');
  idMessage1.Body.Add('<head>');
  idMessage1.Body.Add('<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=iso-8859-1">');
  idMessage1.Body.Add('<title>FBReplicator Emailer</title>');
  idMessage1.Body.Add('</head>');
  idMessage1.Body.Add('<body>');
  idMessage1.Body.Add('<table width="100%" cellspacing=0 cellpadding=3 border=0>');
  idMessage1.Body.Add('<TR>');
  idMessage1.Body.Add('<TD width=32 background=http://www.meta.com.au/images/stories/fbheader_tile.gif>');
  idMessage1.Body.Add('<IMG alt=meta src="http://www.meta.com.au/images/stories/fbrepllogo.gif"></TD>');
  idMessage1.Body.Add('<TD background=http://www.meta.com.au/images/stories/fbheader_tile.gif><font face="Tahoma" size="2"><b>FBReplicator</b></font><br><font face="Tahoma" size="1">This email has been server generated, please do not reply.</font></TD>');
  idMessage1.Body.Add('</TR></table>');
  idMessage1.Body.Add('<p><font face="Tahoma" size="2">'+DateTimeToStr(Now)+': Test email from FBReplicator Manager Utility at <b>'+srReplServer+'</b> via SMTPHost: <b>'+srSMTPHost+'</b></font></p>');
  idMessage1.Body.Add('<p><font face="Tahoma" size="1">This email has been sent by the FBReplicator Manager Utility to test email connections.');
  idMessage1.Body.Add('<br><b>Warning</b>: This computer program is produced as shareware. ');
  idMessage1.Body.Add('The source can be copied, freely distributed, modified, sold or anything else that you wish to do with it. ');
  idMessage1.Body.Add('Certain parts, however, are copyright and it is recommended that appropriate recognition of the copyright holders be displayed somewhere in the distribution.</font>');
  idMessage1.Body.Add('</table>');
  idMessage1.Body.Add('</body>');
  idMessage1.Body.Add('</html>');
  try
    IdSMTP1.Send(idMessage1);
    HandleError('Test email sent to '+srEmail+' via '+srSMTPHost);
  except
    on E:Exception do begin
      HandleError('Error sending error email message: '+E.Message);
      //inc(exceptCount);
    end;
  end;
  IdSMTP1.Disconnect;
end;

procedure TMainControlForm.SpeedButton11Click(Sender: TObject);
var
  bmServerOK: Boolean;
begin
  bmServerOK := True;
  IB_Connection1.Close;
  IB_Connection1.Username := Edit4.Text;
  IB_Connection1.Password := Edit5.Text;
  try
    IB_Connection1.Path := ReplPath.Text;
    IB_Connection1.Server := Edit2.Text;
    IB_Connection1.Connected := True;
    IB_Connection1.Connected := False;
  except
    IB_Connection1.Connected := False;
    bmServerOK := False;
  end;
  if bmServerOK then begin
    MessageDlg(CRLF+'Server name or database name is correct...'+CRLF+'You may save these settings.', mtInformation,
      [mbOK], 0);
  end else begin
    MessageDlg(CRLF+'Server name or database name is incorrect...'+CRLF+'Please correct settings and start again.', mtError,
      [mbOK], 0);
  end;

end;

initialization

end.
