unit Reg;

interface
uses
  FBReplConst, Registry, IniFiles, Forms, SysUtils;

procedure Read_Registry;
procedure Write_Registry;
procedure WriteFormPosition(const F: TCustomForm);
procedure ReadFormPosition(const F: TCustomForm);

implementation

procedure Read_Registry;
begin
  ReplIni := TIniFile.Create(IniFile);
  with ReplIni do begin
    // Server Settings
    brEvtStr := ReadBool('ReplServer', 'EventResp', False);
    srInterval := ReadString('ReplServer', 'Interval', '0');
    brUseEmailAlerts := ReadBool('ReplServer', 'EmailAlerts', False);
    srEmail := ReadString('ReplServer', 'EmailAlertAddress', 'Not Found');
    srFromAddress := ReadString('ReplServer', 'EmailFromAddress', 'domain.com');
    srSMTPHost := ReadString('ReplServer', 'SMTPHost', 'localhost');
    srSMTPLogin := ReadString('ReplServer', 'SMTPLogin', 'Not Found');
    srSMTPPWord := ReadString('ReplServer', 'SMTPPWord', 'Not Found');
    brUseSMTPAuthentication := ReadBool('ReplServer', 'UseSMTPAuthentication', False);
    irTolerance := ReadInteger('ReplServer', 'eTolerance', 5);
    irHeartBeat := ReadInteger('ReplServer', 'HeartBeatCycle', 5);
    srReplLogFile := ReadString('ReplServer', 'LogFile', 'FBReplication.log');
    brVerbose := ReadBool('ReplServer', 'Logging', False);
    brShowStats := ReadBool('ReplServer', 'Stats', False);
    irMaxBlobSize := ReadInteger('ReplServer', 'BlobMaxBytes', MaxBlobSize);
    breHeartbeat := ReadBool('ReplServer', 'eHeartbeat', True);

    // Management Settings
    srReplServer := ReadString('ReplMgmt', 'Server', 'Not Found');
    srReplPath := ReadString('ReplMgmt', 'Path', 'Not Found');
    srReplUser := ReadString('ReplMgmt', 'UserName', 'Not Found');
    srReplPWord := ReadString('ReplMgmt', 'Password', 'Not Found');
    Free;
  end;
end;


procedure Write_Registry;
begin
  ReplIni := TIniFile.Create(IniFile);
  with ReplIni do begin
    // Server Settings
    WriteBool('ReplServer', 'EventResp', brEvtStr);
    WriteString('ReplServer', 'Interval', srInterval);
    WriteBool('ReplServer', 'EmailAlerts', brUseEmailAlerts);
    WriteString('ReplServer', 'EmailAlertAddress', srEmail);
    WriteString('ReplServer', 'EmailFromAddress', srFromAddress);
    WriteString('ReplServer', 'SMTPHost', srSMTPHost);
    WriteString('ReplServer', 'SMTPLogin', srSMTPLogin);
    WriteString('ReplServer', 'SMTPPWord', srSMTPPWord);
    WriteString('ReplServer', 'LogFile', srReplLogFile);
    WriteBool('ReplServer', 'UseSMTPAuthentication', brUseSMTPAuthentication);
    WriteInteger('ReplServer', 'eTolerance', irTolerance );
    WriteInteger('ReplServer', 'HeartBeatCycle', irHeartBeat );
    WriteInteger('ReplServer', 'BlobMaxBytes', irMaxBlobSize);
    WriteBool('ReplServer', 'Logging', brVerbose);
    WriteBool('ReplServer', 'Stats', brShowStats);
    WriteBool('ReplServer', 'eHeartbeat', breHeartbeat);

    // Management Settings
    WriteString('ReplMgmt', 'Server', srReplServer);
    WriteString('ReplMgmt', 'Path', srReplPath);
    WriteString('ReplMgmt', 'UserName', srReplUser);
    WriteString('ReplMgmt', 'Password', srReplPWord);
    Free;
  end;
end;

procedure ReadFormPosition(const F: TCustomForm);
var RegistrySection: String;
begin
  RegistrySection := F.Caption;
  with F, TRegIniFile.Create(RegFile+'\Forms') do
  try
    Left := ReadInteger(RegistrySection, 'FormLeft', Left);
    Top := ReadInteger(RegistrySection, 'FormTop', Top);
    Width := ReadInteger(RegistrySection, 'FormWidth', Width);
    Height :=  ReadInteger(RegistrySection, 'FormHeight', Height);
    if Left < 0 then Left := 0
    else if Left > Screen.Width then Left := Screen.Width - Width;
    if Top < 0 then Top := 0
    else if Top > Screen.Height then Top := Screen.Height - Height;
  finally
    Free;
  end;
end;

procedure WriteFormPosition(const F: TCustomForm);
var RegistrySection: String;
begin
  RegistrySection := F.Caption;
  with F, TRegIniFile.Create(RegFile+'\Forms') do
  try
    WriteInteger(RegistrySection, 'FormLeft', Left);
    WriteInteger(RegistrySection, 'FormTop', Top);
    WriteInteger(RegistrySection, 'FormWidth', Width);
    WriteInteger(RegistrySection, 'FormHeight', Height);
    Write
  finally
    Free;
  end;
end;


end.


